/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.locator;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Locator
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String sui;
    private String isn;
    private String fr;
    private String un;
    private String sna;
    private String soui;
    public static final String XmlName = "locator";

    public Locator() {
        this.sui = "";
        this.isn = "";
        this.fr = "";
        this.un = "";
        this.sna = "";
        this.soui = "";
    }

    public Locator(String sui, String isn, String fr, String un, String sna, String soui) {
        this.sui = sui;
        this.isn = isn;
        this.fr = fr;
        this.un = un;
        this.sna = sna;
        this.soui = soui;
    }

    public Locator(Element loc, Namespace namespace) throws XMLException {
        Element souiChild;
        Element snaChild;
        Element unChild;
        Element frChild;
        Element isnChild;
        Element suiChild = loc.getChild("sui", namespace);
        if (suiChild != null) {
            this.sui = XMLInterpreter.extractString(suiChild);
        }
        if ((isnChild = loc.getChild("isn", namespace)) != null) {
            this.isn = XMLInterpreter.extractString(isnChild);
        }
        if ((frChild = loc.getChild("fr", namespace)) != null) {
            this.fr = XMLInterpreter.extractString(frChild);
        }
        if ((unChild = loc.getChild("un", namespace)) != null) {
            this.un = XMLInterpreter.extractString(unChild);
        }
        if ((snaChild = loc.getChild("sna", namespace)) != null) {
            this.sna = XMLInterpreter.extractString(snaChild);
        }
        if ((souiChild = loc.getChild("soui", namespace)) != null) {
            this.soui = XMLInterpreter.extractString(souiChild);
        }
    }

    public static Locator getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("locator must be the name of the first element");
            }
            return new Locator(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setSUI(String sui) {
        this.sui = sui;
    }

    public String getSUI() {
        return this.sui;
    }

    public void setISN(String isn) {
        this.isn = isn;
    }

    public String getISN() {
        return this.isn;
    }

    public void setFR(String fr) {
        this.fr = fr;
    }

    public String getFR() {
        return this.fr;
    }

    public void setUN(String un) {
        this.un = un;
    }

    public String getUN() {
        return this.un;
    }

    public void setSNA(String sna) {
        this.sna = sna;
    }

    public String getSNA() {
        return this.sna;
    }

    public void setSOUI(String soui) {
        this.soui = soui;
    }

    public String getSOUI() {
        return this.soui;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("SUI:      " + this.sui);
        out.println("ISN:      " + this.isn);
        out.println("FR:       " + this.fr);
        out.println("UN:       " + this.un);
        out.println("SNA:       " + this.sna);
        out.println("SOUI:       " + this.soui);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        Locator.xmlize(xml, this.sui, this.isn, this.fr, this.un, this.sna, this.soui);
    }

    public static void xmlize(StringBuffer xml, String sui, String isn, String fr, String un, String sna, String soui) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 340);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        if (sui != null && !sui.equals("")) {
            xml.append(tab);
            xml.append("<sui>");
            xml.append(Str.escape(sui));
            xml.append("</sui>\n");
        }
        if (isn != null && !isn.equals("")) {
            xml.append(tab);
            xml.append("<isn>");
            xml.append(Str.escape(isn));
            xml.append("</isn>\n");
        }
        if (fr != null && !fr.equals("")) {
            xml.append(tab);
            xml.append("<fr>");
            xml.append(Str.escape(fr));
            xml.append("</fr>\n");
        }
        if (un != null && !un.equals("")) {
            xml.append(tab);
            xml.append("<un>");
            xml.append(Str.escape(un));
            xml.append("</un>\n");
        }
        if (sna != null && !sna.equals("")) {
            xml.append(tab);
            xml.append("<sna>");
            xml.append(Str.escape(sna));
            xml.append("</sna>\n");
        }
        if (soui != null && !soui.equals("")) {
            xml.append(tab);
            xml.append("<soui>");
            xml.append(Str.escape(soui));
            xml.append("</soui>\n");
        }
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String soui;
        String sna;
        String un;
        String fr;
        String isn;
        if (!(c instanceof Locator)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        Locator comp = (Locator)c;
        boolean ret = true;
        String sui = this.getSUI();
        if (!Str.compareStr(sui, comp.getSUI())) {
            if (out != null) {
                out.println("this->SUI='" + sui + "' is different from '" + comp.getSUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(isn = this.getISN(), comp.getISN())) {
            if (out != null) {
                out.println("this->ISN='" + isn + "' is different from '" + comp.getISN() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(fr = this.getFR(), comp.getFR())) {
            if (out != null) {
                out.println("this->FR='" + fr + "' is different from '" + comp.getFR() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(un = this.getUN(), comp.getUN())) {
            if (out != null) {
                out.println("this->UN='" + un + "' is different from '" + comp.getUN() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(sna = this.getSNA(), comp.getSNA())) {
            if (out != null) {
                out.println("this->SNA='" + sna + "' is different from '" + comp.getSNA() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(soui = this.getSOUI(), comp.getSOUI())) {
            if (out != null) {
                out.println("this->SOUI='" + soui + "' is different from '" + comp.getSOUI() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        if (this.sui == null) {
            return this.sna;
        }
        return this.sui;
    }
}

