/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.locator;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.meta.locator.Locator;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class LocatorVector
extends KSCuiVector {
    public static final String XmlName = "LocatorCollection";
    public static final String XmlStructure = "1.0";

    public LocatorVector(Vector locs) {
        super(locs, XmlName, XmlStructure);
    }

    public LocatorVector(LocatorVector locs) {
        super(locs, XmlName, XmlStructure);
    }

    public LocatorVector() {
        super(XmlName, XmlStructure);
    }

    public LocatorVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        String childName = "locator";
        List locators = root.getChildren(childName, namespace);
        if (locators == null || locators.size() == 0) {
            return;
        }
        int i = 0;
        while (i < locators.size()) {
            Element locElem = (Element)locators.get(i);
            Locator loc = new Locator(locElem, namespace);
            if (loc == null) {
                throw new XMLException("Invalid locator definition");
            }
            this.add(loc);
            ++i;
        }
    }

    public static LocatorVector getInstance(String xml) {
        LocatorVector aev = null;
        try {
            aev = new LocatorVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.locator.LocatorVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            LocatorVector vec = LocatorVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No locators read");
                return;
            }
            System.out.println("Number of locators: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Locator locator = (Locator)iter.next();
                System.out.println("Locator----------------");
                locator.output();
                System.out.println("Locator END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

