/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.meshentry;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.meshentry.MeSHEntry;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class MeSHEntryVector
extends KSVector {
    public static final String XmlName = "MeSHEntryCollection";
    public static final String XmlStructure = "1.0";
    private String cui;

    public MeSHEntryVector(Vector entries) {
        super(entries, XmlName, XmlStructure);
    }

    public MeSHEntryVector(MeSHEntryVector entries) {
        super(entries, XmlName, XmlStructure);
    }

    public MeSHEntryVector() {
        super(XmlName, XmlStructure);
    }

    public MeSHEntryVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        Element cuiChild = root.getChild("cui", namespace);
        this.cui = cuiChild == null ? "" : XMLInterpreter.extractString(cuiChild);
        String childName = "MeSHEntry";
        List entries = root.getChildren(childName, namespace);
        if (entries == null || entries.size() == 0) {
            return;
        }
        int i = 0;
        while (i < entries.size()) {
            Element entryElem = (Element)entries.get(i);
            MeSHEntry entry = new MeSHEntry(entryElem, namespace);
            if (entry == null) {
                throw new XMLException("Invalid MeSH Entry definition");
            }
            this.add(entry);
            ++i;
        }
    }

    public static MeSHEntryVector getInstance(String xml) {
        MeSHEntryVector aev = null;
        try {
            aev = new MeSHEntryVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public String getCUI() {
        return this.cui;
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public String getTermName() {
        return "";
    }

    public void setTermName(String termName) {
    }

    protected void writeContents(StringBuffer xml) {
        String tab = "      ";
        if (this.cui != null && !this.cui.equals("")) {
            xml.append(tab);
            xml.append("<cui>");
            xml.append(Str.escape(this.cui));
            xml.append("</cui>\n");
        }
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            xml.append(((Xmlizable)iter.next()).xmlize());
        }
    }

    protected boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof MeSHEntryVector)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        boolean ret = super.doCompare(c, out, equalsFlag);
        if (!ret & this.performanceMode()) {
            return false;
        }
        MeSHEntryVector comp = (MeSHEntryVector)c;
        String cui = this.getCUI();
        if (!Str.compareStr(cui, comp.getCUI())) {
            if (out != null) {
                out.println("this->CUI=" + cui + " is different from " + comp.getCUI());
            }
            ret = false;
            if (this.performanceMode()) {
                return ret;
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.meshentry.MeSHEntryVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            MeSHEntryVector vec = MeSHEntryVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No mesh entries read");
                return;
            }
            System.out.println("Number of mesh entries: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                MeSHEntry entry = (MeSHEntry)iter.next();
                System.out.println("MeSHEntry----------------");
                entry.output();
                System.out.println("MeSHEntry END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

