/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.meshentry;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.meshentry.MeSHInfo;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class MeSHInfoVector
extends KSVector {
    public static final String XmlName = "MeSHInfoCollection";
    public static final String XmlStructure = "1.0";

    public MeSHInfoVector(Vector info) {
        super(info, XmlName, XmlStructure);
    }

    public MeSHInfoVector(MeSHInfoVector info) {
        super(info, XmlName, XmlStructure);
    }

    public MeSHInfoVector() {
        super(XmlName, XmlStructure);
    }

    public MeSHInfoVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "MeSHInfo";
        List entries = root.getChildren(childName, namespace);
        if (entries == null || entries.size() == 0) {
            return;
        }
        int i = 0;
        while (i < entries.size()) {
            Element entryElem = (Element)entries.get(i);
            MeSHInfo entry = new MeSHInfo(entryElem, namespace);
            if (entry == null) {
                throw new XMLException("Invalid MeSH Info definition");
            }
            this.add(entry);
            ++i;
        }
    }

    public static MeSHInfoVector getInstance(String xml) {
        MeSHInfoVector aev = null;
        try {
            aev = new MeSHInfoVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.meta.meshentry.MeSHInfoVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            MeSHInfoVector vec = MeSHInfoVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No mesh entries read");
                return;
            }
            System.out.println("Number of mesh entries: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                MeSHInfo entry = (MeSHInfo)iter.next();
                System.out.println("MeSHInfo----------------");
                entry.output();
                System.out.println("MeSHInfo END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

