/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.relation;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.concept.Concept;
import gov.nih.nlm.kss.models.meta.relation.RelSource;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Relation
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String cui;
    private String cn;
    private String aui;
    private String type;
    private String sab;
    private String sl;
    private Vector relSources;
    public static final String XmlName = "relation";
    private boolean performance = false;

    public Relation() {
        this.cui = "";
        this.cn = "";
        this.aui = "";
        this.type = "";
        this.sab = "";
        this.sl = "";
        this.relSources = null;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Relation(Concept con1, String rel, Concept con2, String rela, String sab, String sl, String mg) {
        this.cui = con1 != null ? con1.getCUI() : "";
        this.aui = "";
        this.type = "";
        this.sab = sab;
        this.sl = sl;
        RelSource r = new RelSource();
        r.setRel(rel);
        String cui2 = "";
        cui2 = con2 != null ? con2.getCUI() : "";
        r.setCUI(cui2);
        r.setRelA(rela);
        r.setAutoGen(mg);
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Relation(String cui, Element relation, Namespace namespace) throws XMLException {
        this(relation, namespace);
        this.setCUI(cui);
    }

    public Relation(Element relation, Namespace namespace) throws XMLException {
        Element sabChild;
        Element auiChild;
        Element relSrcChild = relation.getChild("relSource", namespace);
        if (relSrcChild == null) {
            this.readOldFormat(relation, namespace);
            return;
        }
        Element typeChild = relation.getChild("type", namespace);
        if (typeChild != null) {
            this.type = XMLInterpreter.extractString(typeChild);
        }
        if ((auiChild = relation.getChild("aui", namespace)) != null) {
            this.aui = XMLInterpreter.extractString(auiChild);
        }
        if ((sabChild = relation.getChild("sab", namespace)) == null) {
            throw new XMLException("No source abbreviation <sab> found for version 2.0 format");
        }
        this.sab = XMLInterpreter.extractString(sabChild);
        Element slChild = relation.getChild("sl", namespace);
        if (slChild == null) {
            throw new XMLException("No source level <sl> found for version 2.0 format");
        }
        this.sl = XMLInterpreter.extractString(slChild);
        List relSrcs = relation.getChildren("relSource", namespace);
        if (relSrcs == null || relSrcs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < relSrcs.size()) {
            Element rel = (Element)relSrcs.get(i);
            RelSource relSrc = new RelSource(rel, namespace);
            if (relSrc == null) {
                throw new XMLException("Invalid relSource definition");
            }
            this.addRelSource(relSrc);
            ++i;
        }
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    private void readOldFormat(Element relation, Namespace namespace) throws XMLException {
        Element sabChild = relation.getChild("sab", namespace);
        if (sabChild == null) {
            throw new XMLException("No source abbreviation <sab> found for version 1.0 format");
        }
        this.sab = XMLInterpreter.extractString(sabChild);
        Element slChild = relation.getChild("sl", namespace);
        if (slChild == null) {
            throw new XMLException("No source level <sl> found for version 1.0 format");
        }
        this.sl = XMLInterpreter.extractString(slChild);
        this.aui = "";
        this.type = "";
        Element relChild = relation.getChild("rel", namespace);
        if (relChild == null) {
            throw new XMLException("No relation <rel> found for version 1.0 format");
        }
        String rel = XMLInterpreter.extractString(relChild);
        Element cui2Child = relation.getChild("cui2", namespace);
        if (cui2Child == null) {
            throw new XMLException("No concept unique identifier for concept 2 <cui2> found for version 1.0 format");
        }
        String cui2 = XMLInterpreter.extractString(cui2Child);
        Element cn2Child = relation.getChild("cn2", namespace);
        if (cn2Child == null) {
            throw new XMLException("No concept name for concept 2 <cn2> found for version 1.0 format");
        }
        String cn2 = XMLInterpreter.extractString(cn2Child);
        Element relaChild = relation.getChild("rela", namespace);
        if (relaChild == null) {
            throw new XMLException("No semantic network relationship <rela> found for version 1.0 format");
        }
        String rela = XMLInterpreter.extractString(relaChild);
        Element mgChild = relation.getChild("mg", namespace);
        String mg = null;
        if (mgChild != null) {
            mg = XMLInterpreter.extractString(mgChild);
        }
        RelSource relSrc = new RelSource();
        relSrc.setRel(rel);
        relSrc.setCUI(cui2);
        relSrc.setCN(cn2);
        relSrc.setRelA(rela);
        relSrc.setAutoGen(mg);
        this.addRelSource(relSrc);
    }

    public static Relation getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("relation must be the name of the first element");
            }
            return new Relation("", root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public Concept getCon1() {
        return null;
    }

    public void setCon1(Concept c1) {
        if (c1 != null) {
            this.setCUI(c1.getCUI());
        }
    }

    public String getCUI1() {
        return this.getCUI();
    }

    public String getCUI() {
        return this.cui;
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public String getCN() {
        return this.cn;
    }

    public void setCN(String cn) {
        this.cn = cn;
    }

    public String getAUI() {
        return this.aui;
    }

    public void setAUI(String aui) {
        this.aui = aui;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRel() {
        return null;
    }

    public void setRel(String rel) {
    }

    public Concept getCon2() {
        return null;
    }

    public void setCon2(Concept c2) {
    }

    public String getCUI2() {
        return null;
    }

    public void setRelA(String rela) {
    }

    public String getRelA() {
        return null;
    }

    public void setSAB(String sab) {
        this.sab = sab;
    }

    public String getSAB() {
        return this.sab;
    }

    public void setSL(String sl) {
        this.sl = sl;
    }

    public String getSL() {
        return this.sl;
    }

    public void setMG(String mg) {
    }

    public String getMG() {
        return null;
    }

    public void setRelSources(Vector relSources) {
        this.relSources = relSources;
    }

    public void addRelSource(RelSource relSrc) {
        if (this.relSources == null) {
            this.relSources = new Vector();
        }
        this.relSources.add(relSrc);
    }

    public Vector getRelSources() {
        return this.relSources;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("AUI:  " + this.aui);
        out.println("Type: " + this.type);
        out.println("SAB:  " + this.sab);
        out.println("SL:   " + this.sl);
        if (this.relSources == null) {
            return;
        }
        Iterator iter = this.relSources.iterator();
        while (iter.hasNext()) {
            ((RelSource)iter.next()).output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String msab;
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 500);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        if (this.aui != null && !this.aui.equals("")) {
            String maui = this.aui;
            if (maui == null) {
                maui = "";
            }
            xml.append(tab);
            xml.append("<aui>");
            xml.append(maui);
            xml.append("</aui>\n");
        }
        if (this.type != null && !this.type.equals("")) {
            String mtype = this.type;
            if (mtype == null) {
                mtype = "";
            }
            xml.append(tab);
            xml.append("<type>");
            xml.append(mtype);
            xml.append("</type>\n");
        }
        if ((msab = this.sab) == null) {
            msab = "";
        }
        xml.append(tab);
        xml.append("<sab>");
        xml.append(msab);
        xml.append("</sab>\n");
        String msl = this.sl;
        if (msl == null) {
            msl = "";
        }
        xml.append(tab);
        xml.append("<sl>");
        xml.append(msl);
        xml.append("</sl>\n");
        if (this.relSources != null) {
            Iterator iter = this.relSources.iterator();
            while (iter.hasNext()) {
                xml.append(((RelSource)iter.next()).xmlize());
            }
        }
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public static void xmlize(StringBuffer xml, String rel, String cui2, String cn2, String rela, String sab, String sl, String mg) {
        Relation relation = new Relation();
        relation.setSAB(sab);
        relation.setSL(sl);
        RelSource relSrc = new RelSource();
        relSrc.setCUI(cui2);
        relSrc.setCN(cn2);
        relSrc.setRel(rel);
        relSrc.setRelA(rela);
        relSrc.setAutoGen(mg);
        relation.addRelSource(relSrc);
        xml.append(relation.xmlize());
        relation = null;
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String type;
        String aui;
        if (!(c instanceof Relation)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        Relation comp = (Relation)c;
        boolean ret = true;
        String cui = this.getCUI();
        if (!Str.compareStr(cui, comp.getCUI())) {
            if (out != null) {
                out.println("this->CUI='" + cui + "' is different from '" + comp.getCUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(aui = this.getAUI(), comp.getAUI())) {
            if (out != null) {
                out.println("this->AUI='" + aui + "' is different from '" + comp.getAUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(type = this.getType(), comp.getType())) {
            if (out != null) {
                out.println("this->Type='" + type + "' is different from '" + comp.getType() + "'");
            }
            ret = false;
        }
        String lsab = this.getSAB();
        String csab = comp.getSAB();
        if (!equalsFlag) {
            lsab = CompareUtil.logicalEquivSAB(lsab);
            csab = CompareUtil.logicalEquivSAB(csab);
        }
        if (!Str.compareStr(lsab, csab)) {
            if (out != null) {
                out.println("this->SAB='" + this.sab + "' is different from '" + comp.getSAB() + "'");
            }
            ret = false;
        }
        String lsl = this.getSL();
        String csl = comp.getSL();
        if (!equalsFlag) {
            lsl = CompareUtil.logicalEquivSAB(lsl);
            csl = CompareUtil.logicalEquivSAB(csl);
        }
        if (!Str.compareStr(lsl, csl)) {
            if (out != null) {
                out.println("this->SL='" + this.sl + "' is different from '" + comp.getSL() + "'");
            }
            ret = false;
        }
        Vector srcs = comp.getRelSources();
        if (this.relSources == null && srcs != null || this.relSources != null && srcs == null) {
            if (out != null) {
                out.println("RelSources are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.relSources == null && srcs == null) {
            return ret;
        }
        if (this.relSources.size() != srcs.size()) {
            if (out != null) {
                out.println("RelSources are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(srcs);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.relSources);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            RelSource val = (RelSource)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    RelSource missing = (RelSource)compht.get(compkey);
                    out.println("RelSource missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            RelSource val2 = (RelSource)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            RelSource val = (RelSource)thisht.get(thiskey);
            if (out == null) continue;
            RelSource added = (RelSource)thisht.get(thiskey);
            out.println("RelSource added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, RelSource> table = new Hashtable<String, RelSource>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            RelSource val = (RelSource)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        if (this.cui != null) {
            return this.cui + this.aui + this.type + this.sab + this.sl;
        }
        return this.aui + this.type + this.sab + this.sl;
    }
}

