/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.source;

import gov.nih.nlm.kss.util.ConstantSettings;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jdom.Namespace;

public class SourceV2_1
extends XMLInterpreter
implements Serializable {
    private String sab;
    private String name;
    private String nickName;
    public static final String XmlName = "sourceDef";
    static boolean initialized = false;
    static HashMap hashMap = new HashMap();

    public SourceV2_1() {
        this.sab = "";
        this.name = "";
        this.nickName = "";
    }

    public SourceV2_1(String sab, String name, String nickName) {
        this.sab = sab;
        this.name = name;
        this.nickName = nickName;
    }

    public SourceV2_1(Element source, Namespace namespace) throws XMLException {
        Element sabChild = source.getChild("sab", namespace);
        if (sabChild == null) {
            throw new XMLException("No source abbreviation <sab> found");
        }
        this.sab = XMLInterpreter.extractString(sabChild);
        Element nameChild = source.getChild("name", namespace);
        if (nameChild == null) {
            throw new XMLException("No source long name <name> found");
        }
        this.name = XMLInterpreter.extractString(nameChild);
        Element nicknameChild = source.getChild("nickname", namespace);
        if (nicknameChild == null) {
            throw new XMLException("No source short name <nickname> found");
        }
        this.nickName = XMLInterpreter.extractString(nicknameChild);
    }

    public String getSAB() {
        return this.sab;
    }

    public void setSAB(String rsab) {
        this.sab = rsab;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNickName(String nickname) {
        this.nickName = nickname;
    }

    public String getNickName() {
        return this.nickName;
    }

    private static void init() throws Exception {
        String s;
        BufferedReader br;
        if (initialized) {
            return;
        }
        initialized = true;
        String fileName = ConstantSettings.getSourceFileName();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        }
        catch (Exception ex) {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        }
        StringTokenizer st = null;
        String sab = null;
        String name = null;
        String nickName = null;
        while ((s = br.readLine()) != null) {
            st = new StringTokenizer((String)ex, "|");
            if (st.hasMoreTokens()) {
                sab = st.nextToken();
                name = st.nextToken();
                nickName = st.nextToken();
            }
            hashMap.put(sab, new SourceV2_1(sab, name, nickName));
        }
    }

    private static void writeSourceV2_1(StringBuffer xml, SourceV2_1 src) {
        String tab0 = "\t";
        String tab1 = "\t\t";
        xml.append(tab0);
        xml.append("<sourceDef>\n");
        xml.append(tab1);
        xml.append("<sab>");
        xml.append(Str.escape(src.getSAB()));
        xml.append("</sab>\n");
        xml.append(tab1);
        xml.append("<name>");
        xml.append(Str.escape(src.getName()));
        xml.append("</name>\n");
        xml.append(tab1);
        xml.append("<nickname>");
        xml.append(Str.escape(src.getNickName()));
        xml.append("</nickname>\n");
        xml.append(tab0);
        xml.append("</sourceDef>\n");
    }

    private static void main(String[] args) {
        if (args.length < 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.source.SourceV2_1 ");
            System.out.print("<XML_URI> ");
            System.out.println("<searchName-1> ... <searchName-N>");
            return;
        }
        String srcFile = args[0];
        System.setProperty("KssSourceV2_1File", srcFile);
    }
}

