/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.rels;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSObject;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class AssociativeRelExistence
extends KSObject {
    public static final String XmlName = "AssociativeRelExistence";
    public static final String XmlStructure = "1.0";
    private String lhs_semtype;
    private String relation;
    private String rhs_semtype;
    private int exists;

    public AssociativeRelExistence() {
        super(XmlName, XmlStructure);
        this.lhs_semtype = "";
        this.relation = "";
        this.rhs_semtype = "";
        this.exists = 2;
    }

    public AssociativeRelExistence(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    public AssociativeRelExistence(AssociativeRelExistence are) {
        super(are, XmlName, XmlStructure);
        this.lhs_semtype = are.getLHSSemType();
        this.relation = are.getRelation();
        this.rhs_semtype = are.getRHSSemType();
        this.exists = are.getExists();
    }

    public AssociativeRelExistence(Element root, Namespace namespace) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(root, namespace);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        Element lhs_semtypeChild = root.getChild("lhs_semtype", namespace);
        if (lhs_semtypeChild == null) {
            throw new XMLException("No semantic type <lhs_semtype> found");
        }
        this.lhs_semtype = XMLInterpreter.extractString(lhs_semtypeChild);
        Element relationChild = root.getChild("relation", namespace);
        if (relationChild == null) {
            throw new XMLException("No semantic type <relation> found");
        }
        this.relation = XMLInterpreter.extractString(relationChild);
        Element rhs_semtypeChild = root.getChild("rhs_semtype", namespace);
        if (rhs_semtypeChild == null) {
            throw new XMLException("No semantic type <rhs_semtype> found");
        }
        this.rhs_semtype = XMLInterpreter.extractString(rhs_semtypeChild);
        Element existsChild = root.getChild("direct", namespace);
        if (existsChild != null) {
            this.exists = 0;
            return;
        }
        existsChild = root.getChild("inherited", namespace);
        if (existsChild != null) {
            this.exists = 1;
            return;
        }
        existsChild = root.getChild("nonExistent", namespace);
        if (existsChild != null) {
            this.exists = 2;
            return;
        }
        throw new XMLException("No existence indicator <direct>, <inherited> or <nonExistent> found");
    }

    public static AssociativeRelExistence getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("AssociativeRelExistence must be the name of the first element");
            }
            return new AssociativeRelExistence(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getLHSSemType() {
        return this.lhs_semtype;
    }

    public void setLHSSemType(String lhs_semtype) {
        this.lhs_semtype = lhs_semtype;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String rel) {
        this.relation = rel;
    }

    public String getRHSSemType() {
        return this.rhs_semtype;
    }

    public void setRHSSemType(String rhs_semtype) {
        this.rhs_semtype = rhs_semtype;
    }

    public int getExists() {
        return this.exists;
    }

    public void setExists(int exists) {
        if (exists != 0 && exists != 1 && exists != 2) {
            return;
        }
        this.exists = exists;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("Associative Relation Existence:");
        out.println("  LHS SemType: " + this.lhs_semtype);
        out.println("  Relation:    " + this.relation);
        out.println("  RHS SemType: " + this.rhs_semtype);
        out.println("  Existence:   " + this.exists);
    }

    protected void writeContents(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        String mlhs_semtype = this.lhs_semtype;
        if (mlhs_semtype == null) {
            mlhs_semtype = "";
        }
        xml.append(tab);
        xml.append("<lhs_semtype>");
        xml.append(Str.escape(mlhs_semtype));
        xml.append("</lhs_semtype>\n");
        String mrelation = this.relation;
        if (mrelation == null) {
            mrelation = "";
        }
        xml.append(tab);
        xml.append("<relation>");
        xml.append(mrelation);
        xml.append("</relation>\n");
        String mrhs_semtype = this.rhs_semtype;
        if (mrhs_semtype == null) {
            mrhs_semtype = "";
        }
        xml.append(tab);
        xml.append("<rhs_semtype>");
        xml.append(Str.escape(mrhs_semtype));
        xml.append("</rhs_semtype>\n");
        if (this.exists == 0) {
            xml.append(tab);
            xml.append("<direct/>\n");
        } else if (this.exists == 1) {
            xml.append(tab);
            xml.append("<inherited/>\n");
        } else if (this.exists == 2) {
            xml.append(tab);
            xml.append("<nonExistent/>\n");
        }
    }

    protected boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof AssociativeRelExistence)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        boolean ret = super.doCompare(c, out, equalsFlag);
        if (!ret & this.performanceMode()) {
            return ret;
        }
        AssociativeRelExistence comp = (AssociativeRelExistence)c;
        if (!Str.compareStr(this.lhs_semtype, comp.getLHSSemType())) {
            if (out != null) {
                out.println("this->LHSSemType='" + this.lhs_semtype + "' is different from '" + comp.getLHSSemType() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.relation, comp.getRelation())) {
            if (out != null) {
                out.println("this->Relation='" + this.relation + "' is different from '" + comp.getRelation() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.rhs_semtype, comp.getRHSSemType())) {
            if (out != null) {
                out.println("this->RHSSemType='" + this.rhs_semtype + "' is different from '" + comp.getRHSSemType() + "'");
            }
            ret = false;
        }
        if (this.exists != comp.getExists()) {
            if (out != null) {
                out.println("this->Exists='" + this.exists + "' is different from '" + comp.getExists() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.lhs_semtype + this.relation + this.rhs_semtype;
    }
}

