/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.rels;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSObject;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class HierRelRelExistence
extends KSObject {
    public static final String XmlName = "HierRelRelExistence";
    public static final String XmlStructure = "1.0";
    private String lhs_semrel;
    private String relation;
    private String rhs_semrel;
    private int exists;

    public HierRelRelExistence() {
        super(XmlName, XmlStructure);
        this.lhs_semrel = "";
        this.relation = "";
        this.rhs_semrel = "";
        this.exists = 2;
    }

    public HierRelRelExistence(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    public HierRelRelExistence(HierRelRelExistence are) {
        super(are, XmlName, XmlStructure);
        this.lhs_semrel = are.getLHSSemRel();
        this.relation = are.getRelation();
        this.rhs_semrel = are.getRHSSemRel();
        this.exists = are.getExists();
    }

    public HierRelRelExistence(Element root, Namespace namespace) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(root, namespace);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        Element lhs_semrelChild = root.getChild("lhs_semrel", namespace);
        if (lhs_semrelChild == null) {
            throw new XMLException("No semantic relation <lhs_semrel> found");
        }
        this.lhs_semrel = XMLInterpreter.extractString(lhs_semrelChild);
        Element relationChild = root.getChild("relation", namespace);
        if (relationChild == null) {
            throw new XMLException("No semantic relation <relation> found");
        }
        this.relation = XMLInterpreter.extractString(relationChild);
        Element rhs_semrelChild = root.getChild("rhs_semrel", namespace);
        if (rhs_semrelChild == null) {
            throw new XMLException("No semantic relation <rhs_semrel> found");
        }
        this.rhs_semrel = XMLInterpreter.extractString(rhs_semrelChild);
        Element existsChild = root.getChild("direct", namespace);
        if (existsChild != null) {
            this.exists = 0;
            return;
        }
        existsChild = root.getChild("inherited", namespace);
        if (existsChild != null) {
            this.exists = 1;
            return;
        }
        existsChild = root.getChild("nonExistent", namespace);
        if (existsChild != null) {
            this.exists = 2;
            return;
        }
        throw new XMLException("No existence indicator <direct>, <inherited> or <nonExistent> found");
    }

    public static HierRelRelExistence getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("HierRelRelExistence must be the name of the first element");
            }
            return new HierRelRelExistence(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getLHSSemRel() {
        return this.lhs_semrel;
    }

    public void setLHSSemRel(String lhs_semrel) {
        this.lhs_semrel = lhs_semrel;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String rel) {
        this.relation = rel;
    }

    public String getRHSSemRel() {
        return this.rhs_semrel;
    }

    public void setRHSSemRel(String rhs_semrel) {
        this.rhs_semrel = rhs_semrel;
    }

    public int getExists() {
        return this.exists;
    }

    public void setExists(int exists) {
        if (exists != 0 && exists != 1 && exists != 2) {
            return;
        }
        this.exists = exists;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("Associative Relation Existence:");
        out.println("  LHS SemRel: " + this.lhs_semrel);
        out.println("  Relation:    " + this.relation);
        out.println("  RHS SemRel: " + this.rhs_semrel);
        out.println("  Existence:   " + this.exists);
    }

    public void writeContents(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        String mlhs_semrel = this.lhs_semrel;
        if (mlhs_semrel == null) {
            mlhs_semrel = "";
        }
        xml.append(tab);
        xml.append("<lhs_semrel>");
        xml.append(Str.escape(mlhs_semrel));
        xml.append("</lhs_semrel>\n");
        String mrelation = this.relation;
        if (mrelation == null) {
            mrelation = "";
        }
        xml.append(tab);
        xml.append("<relation>");
        xml.append(mrelation);
        xml.append("</relation>\n");
        String mrhs_semrel = this.rhs_semrel;
        if (mrhs_semrel == null) {
            mrhs_semrel = "";
        }
        xml.append(tab);
        xml.append("<rhs_semrel>");
        xml.append(Str.escape(mrhs_semrel));
        xml.append("</rhs_semrel>\n");
        if (this.exists == 0) {
            xml.append(tab);
            xml.append("<direct/>\n");
        } else if (this.exists == 1) {
            xml.append(tab);
            xml.append("<inherited/>\n");
        } else if (this.exists == 2) {
            xml.append(tab);
            xml.append("<nonExistent/>\n");
        }
    }

    protected boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String rhs_semrel;
        String relation;
        if (!(c instanceof HierRelRelExistence)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        boolean ret = super.doCompare(c, out, equalsFlag);
        if (!ret & this.performanceMode()) {
            return ret;
        }
        HierRelRelExistence comp = (HierRelRelExistence)c;
        String lhs_semrel = this.getLHSSemRel();
        if (!Str.compareStr(lhs_semrel, comp.getLHSSemRel())) {
            if (out != null) {
                out.println("this->LHSSemRel='" + lhs_semrel + "' is different from '" + comp.getLHSSemRel() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(relation = this.getRelation(), comp.getRelation())) {
            if (out != null) {
                out.println("this->Relation='" + relation + "' is different from '" + comp.getRelation() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(rhs_semrel = this.getRHSSemRel(), comp.getRHSSemRel())) {
            if (out != null) {
                out.println("this->RHSSemRel='" + rhs_semrel + "' is different from '" + comp.getRHSSemRel() + "'");
            }
            ret = false;
        }
        if (this.exists != comp.getExists()) {
            if (out != null) {
                out.println("this->Exists='" + this.exists + "' is different from '" + comp.getExists() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.lhs_semrel + this.relation + this.rhs_semrel;
    }
}

