/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.units;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.sem.units.HierSemanticTypeVector;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class HierSemanticType
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private boolean expanded;
    private String name;
    private String ui;
    private String treeNum;
    private String definition;
    private String usage;
    private String nhFlag;
    private String abbrev;
    private Vector examples;
    private String parentUI;
    private HierSemanticTypeVector children;
    private Vector childrenUIs;
    public static final String XmlName = "semType";

    public HierSemanticType() {
        this.name = "";
        this.ui = "";
        this.treeNum = "";
        this.definition = "";
        this.examples = null;
        this.usage = "";
        this.nhFlag = "";
        this.parentUI = "";
        this.abbrev = "";
        this.children = null;
        this.childrenUIs = null;
        this.expanded = false;
    }

    public HierSemanticType(Element semtype, Namespace namespace) throws XMLException {
        List uis;
        Element parentUIChild;
        Element abbrevChild;
        Element nhFlagChild;
        Element usageChild;
        Element exChild;
        Element defChild;
        Element nameChild = semtype.getChild("name", namespace);
        if (nameChild == null) {
            throw new XMLException("No semantic type <name> found");
        }
        this.name = XMLInterpreter.extractString(nameChild);
        Element uiChild = semtype.getChild("ui", namespace);
        if (uiChild == null) {
            throw new XMLException("No semantic type <ui> found");
        }
        this.ui = XMLInterpreter.extractString(uiChild);
        Element treeNumChild = semtype.getChild("treeNum", namespace);
        if (treeNumChild != null) {
            this.treeNum = XMLInterpreter.extractString(treeNumChild);
        }
        if ((defChild = semtype.getChild("def", namespace)) != null) {
            this.definition = XMLInterpreter.extractString(defChild);
        }
        if ((exChild = semtype.getChild("ex", namespace)) != null) {
            this.examples = new Vector();
            String exs = XMLInterpreter.extractString(exChild);
            if (exs != null) {
                StringTokenizer tokenizer = new StringTokenizer(exs, ";");
                while (tokenizer.hasMoreTokens()) {
                    this.examples.add(tokenizer.nextToken());
                }
            }
        }
        if ((usageChild = semtype.getChild("usage", namespace)) != null) {
            this.usage = XMLInterpreter.extractString(usageChild);
        }
        if ((nhFlagChild = semtype.getChild("nhFlag", namespace)) != null) {
            this.nhFlag = XMLInterpreter.extractString(nhFlagChild);
        }
        if ((abbrevChild = semtype.getChild("abbrev", namespace)) != null) {
            this.abbrev = XMLInterpreter.extractString(abbrevChild);
        }
        if ((parentUIChild = semtype.getChild("parentUI", namespace)) == null) {
            throw new XMLException("No semantic type <parentUI> found");
        }
        this.parentUI = XMLInterpreter.extractString(parentUIChild);
        Element childrenEle = semtype.getChild("children", namespace);
        if (childrenEle == null) {
            return;
        }
        String childName = XmlName;
        this.expanded = false;
        List ids = childrenEle.getChildren(childName, namespace);
        if ((ids == null || ids.size() == 0) && (uis = childrenEle.getChildren("ui", namespace)) != null && uis.size() != 0) {
            this.children = null;
            this.childrenUIs = new Vector();
            int j = 0;
            while (j < uis.size()) {
                Element uiEle = (Element)uis.get(j);
                String ui = XMLInterpreter.extractString(uiEle);
                this.childrenUIs.add(ui);
                ++j;
            }
            return;
        }
        this.children = new HierSemanticTypeVector();
        int i = 0;
        while (i < ids.size()) {
            Element idEle = (Element)ids.get(i);
            HierSemanticType id = new HierSemanticType(idEle, namespace);
            if (id == null) {
                throw new XMLException("Invalid semantic type definition");
            }
            this.children.add(id);
            ++i;
        }
        this.expanded = true;
    }

    public static HierSemanticType getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("semType must be the name of the first element");
            }
            return new HierSemanticType(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUI() {
        return this.ui;
    }

    public void setUI(String ui) {
        this.ui = ui;
    }

    public String getTreeNum() {
        return this.treeNum;
    }

    public void setTreeNum(String treeNum) {
        this.treeNum = treeNum;
    }

    public String getDef() {
        return this.definition;
    }

    public void setDef(String definition) {
        this.definition = definition;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getNHFlag() {
        return this.nhFlag;
    }

    public void setNHFlag(String nhFlag) {
        this.nhFlag = nhFlag;
    }

    public Vector getExamples() {
        return this.examples;
    }

    public void setExamples(Vector examples) {
        this.examples = examples;
    }

    public void addExample(String example) {
        if (this.examples == null) {
            this.examples = new Vector();
        }
        this.examples.addElement(example);
    }

    public String getParentUI() {
        return this.parentUI;
    }

    public void setParentUI(String parentUI) {
        this.parentUI = parentUI;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public void setAbbrev(String abbrev) {
        this.abbrev = abbrev;
    }

    public HierSemanticTypeVector getChildren() {
        return this.children;
    }

    public void setChildren(HierSemanticTypeVector children) {
        this.children = children;
        if (children != null) {
            this.expanded = true;
        }
    }

    public Vector getChildrenUIs() {
        if (this.children != null) {
            this.childrenUIs.clear();
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                this.childrenUIs.add((String)iter.next());
            }
        }
        return this.childrenUIs;
    }

    public void setChildrenUIs(Vector childrenUIs) {
        this.childrenUIs = new Vector();
        Iterator iter = childrenUIs.iterator();
        while (iter.hasNext()) {
            this.childrenUIs.add(iter.next());
        }
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("Semantic Type:      " + this.name);
        out.println("  UI:          " + this.ui);
        out.println("  TreeNum:     " + this.treeNum);
        out.println("  Definition:  " + this.definition);
        if (this.examples != null) {
            out.println("  Examples:         ");
            Iterator iter2 = this.examples.iterator();
            while (iter2.hasNext()) {
                out.println("      " + (String)iter2.next());
            }
        }
        out.println("  Usage Note:  " + this.usage);
        out.println("  NH Flag:     " + this.nhFlag);
        out.println("  Parent UI:  " + this.parentUI);
        out.println("  Abbrev:     " + this.abbrev);
        if (this.children != null) {
            out.println("  Children:         ");
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                ((HierSemanticType)iter.next()).output();
            }
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        this.xmlize(xml, 0);
    }

    public void xmlize(StringBuffer xml, int indentLevel) {
        Iterator iter;
        String tab0 = "      ";
        String tab = "         ";
        int i = 0;
        while (i < indentLevel) {
            tab0 = tab0 + "    ";
            tab = tab + "    ";
            ++i;
        }
        xml.ensureCapacity(xml.length() + 2000);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        String mname = this.name;
        if (mname == null) {
            mname = "";
        }
        xml.append(tab);
        xml.append("<name>");
        xml.append(Str.escape(mname));
        xml.append("</name>\n");
        String mui = this.ui;
        if (mui == null) {
            mui = "";
        }
        xml.append(tab);
        xml.append("<ui>");
        xml.append(mui);
        xml.append("</ui>\n");
        if (this.treeNum != null && !this.treeNum.equals("")) {
            String mtreeNum = this.treeNum;
            if (mtreeNum == null) {
                mtreeNum = "";
            }
            xml.append(tab);
            xml.append("<treeNum>");
            xml.append(mtreeNum);
            xml.append("</treeNum>\n");
        }
        if (this.definition != null && !this.definition.equals("")) {
            String mdef = this.definition;
            if (mdef == null) {
                mdef = "";
            }
            xml.append(tab);
            xml.append("<def>");
            xml.append(Str.escape(mdef));
            xml.append("</def>\n");
        }
        if (this.examples != null && !this.examples.isEmpty()) {
            xml.append(tab);
            xml.append("<ex>");
            if (this.examples != null) {
                Iterator iter2 = this.examples.iterator();
                while (iter2.hasNext()) {
                    xml.append(Str.escape((String)iter2.next()));
                    if (!iter2.hasNext()) continue;
                    xml.append(";");
                }
            }
            xml.append("</ex>\n");
        }
        if (this.usage != null && !this.usage.equals("")) {
            String musage = this.usage;
            if (musage == null) {
                musage = "";
            }
            xml.append(tab);
            xml.append("<usage>");
            xml.append(Str.escape(musage));
            xml.append("</usage>\n");
        }
        if (this.nhFlag != null && !this.nhFlag.equals("")) {
            String mnhFlag = this.nhFlag;
            if (mnhFlag == null) {
                mnhFlag = "";
            }
            xml.append(tab);
            xml.append("<nhFlag>");
            xml.append(Str.escape(mnhFlag));
            xml.append("</nhFlag>\n");
        }
        if (this.parentUI != null && !this.parentUI.equals("")) {
            String mparentUI = this.parentUI;
            if (mparentUI == null) {
                mparentUI = "";
            }
            xml.append(tab);
            xml.append("<parentUI>");
            xml.append(mparentUI);
            xml.append("</parentUI>\n");
        }
        if (this.abbrev != null && !this.abbrev.equals("")) {
            String mabbrev = this.abbrev;
            if (mabbrev == null) {
                mabbrev = "";
            }
            xml.append(tab);
            xml.append("<abbrev>");
            xml.append(mabbrev);
            xml.append("</abbrev>\n");
        }
        if (this.children != null) {
            xml.ensureCapacity(xml.length() + 20);
            xml.append(tab);
            xml.append("<children>\n");
            iter = this.children.iterator();
            while (iter.hasNext()) {
                ((HierSemanticType)iter.next()).xmlize(xml, indentLevel + 1);
            }
            xml.ensureCapacity(xml.length() + 20);
            xml.append(tab);
            xml.append("</children>\n");
        } else if (this.childrenUIs != null) {
            xml.ensureCapacity(xml.length() + 20);
            xml.append(tab);
            xml.append("<children>\n");
            iter = this.childrenUIs.iterator();
            xml.ensureCapacity(xml.length() + 30 * this.childrenUIs.size());
            while (iter.hasNext()) {
                xml.append(tab);
                xml.append("   <ui>");
                xml.append((String)iter.next());
                xml.append("</ui>\n");
            }
            xml.ensureCapacity(xml.length() + 20);
            xml.append(tab);
            xml.append("</children>\n");
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String abbrev;
        String parentUI;
        String nhFlag;
        String usage;
        String definition;
        String treeNum;
        String ui;
        if (!(c instanceof HierSemanticType)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        HierSemanticType comp = (HierSemanticType)c;
        boolean ret = true;
        String name = this.getName();
        if (!Str.compareStr(name, comp.getName())) {
            if (out != null) {
                out.println("this->Name='" + name + "' is different from '" + comp.getName() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(ui = this.getUI(), comp.getUI())) {
            if (out != null) {
                out.println("this->UI='" + ui + "' is different from '" + comp.getUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(treeNum = this.getTreeNum(), comp.getTreeNum())) {
            if (out != null) {
                out.println("this->TreeNum='" + treeNum + "' is different from '" + comp.getTreeNum() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(definition = this.getDef(), comp.getDef())) {
            if (out != null) {
                out.println("this->Def='" + definition + "' is different from '" + comp.getDef() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(usage = this.getUsage(), comp.getUsage())) {
            if (out != null) {
                out.println("this->Usage='" + usage + "' is different from '" + comp.getUsage() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(nhFlag = this.getNHFlag(), comp.getNHFlag())) {
            if (out != null) {
                out.println("this->NHFlag='" + nhFlag + "' is different from '" + comp.getNHFlag() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(parentUI = this.getParentUI(), comp.getParentUI())) {
            if (out != null) {
                out.println("this->ParentUI='" + parentUI + "' is different from '" + comp.getParentUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(abbrev = this.getAbbrev(), comp.getAbbrev())) {
            if (out != null) {
                out.println("this->Abbrev='" + abbrev + "' is different from '" + comp.getAbbrev() + "'");
            }
            ret = false;
        }
        HierSemanticTypeVector cchildren = comp.getChildren();
        if (this.children != null && cchildren == null || this.children == null && cchildren != null) {
            return false;
        }
        if (this.children == null && cchildren == null) {
            if (ret) {
                return true;
            }
            return ret;
        }
        if (equalsFlag) {
            if (!this.children.equals(cchildren)) {
                ret = false;
            }
        } else if (!this.children.equivalent(cchildren)) {
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.ui;
    }
}

