/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.units;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.sem.units.SemNetId;
import gov.nih.nlm.kss.models.sem.units.SemNetIdVector;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class SemGroup
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String name;
    private String ui;
    private String abbrev;
    private SemNetIdVector semTypeIds;
    public static final String XmlName = "semGroup";

    public SemGroup() {
        this.name = "";
        this.ui = "";
        this.abbrev = "";
        this.semTypeIds = null;
    }

    public SemGroup(Element semgrp, Namespace namespace) throws XMLException {
        Element nameChild = semgrp.getChild("name", namespace);
        if (nameChild == null) {
            throw new XMLException("No semantic group <name> found");
        }
        this.name = XMLInterpreter.extractString(nameChild);
        Element uiChild = semgrp.getChild("ui", namespace);
        if (uiChild == null) {
            throw new XMLException("No semantic group <ui> found");
        }
        this.ui = XMLInterpreter.extractString(uiChild);
        Element abbrevChild = semgrp.getChild("abbrev", namespace);
        if (abbrevChild == null) {
            throw new XMLException("No semantic group <abbrev> found");
        }
        this.abbrev = XMLInterpreter.extractString(uiChild);
        String childName = "semnetId";
        List stypes = semgrp.getChildren(childName, namespace);
        if (stypes == null || stypes.size() == 0) {
            return;
        }
        this.semTypeIds = new SemNetIdVector();
        int i = 0;
        while (i < stypes.size()) {
            Element st = (Element)stypes.get(i);
            SemNetId stid = new SemNetId(st, namespace);
            if (stid == null) {
                throw new XMLException("Invalid semantic network id definition");
            }
            this.semTypeIds.add(stid);
            ++i;
        }
    }

    public static SemGroup getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("semGroup must be the name of the first element");
            }
            return new SemGroup(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUI() {
        return this.ui;
    }

    public void setUI(String ui) {
        this.ui = ui;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public void setAbbrev(String abbrev) {
        this.abbrev = abbrev;
    }

    public SemNetIdVector getSemTypeIds() {
        return this.semTypeIds;
    }

    public void setSemTypeIds(SemNetIdVector semTypeIds) {
        this.semTypeIds = semTypeIds;
    }

    public void addSemTypeId(SemNetId id) {
        if (this.semTypeIds == null) {
            this.semTypeIds = new SemNetIdVector();
        }
        this.semTypeIds.addElement(id);
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("Semantic Group:");
        out.println("  Name:        " + this.name);
        out.println("  UI:          " + this.ui);
        out.println("  Abbrev:      " + this.abbrev);
        if (this.semTypeIds != null) {
            this.semTypeIds.output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "  ";
        String tab = "     ";
        xml.ensureCapacity(xml.length() + 200);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        String mname = this.name;
        if (mname == null) {
            mname = "";
        }
        xml.append(tab);
        xml.append("<name>");
        xml.append(Str.escape(mname));
        xml.append("</name>\n");
        String mui = this.ui;
        if (mui == null) {
            mui = "";
        }
        xml.append(tab);
        xml.append("<ui>");
        xml.append(mui);
        xml.append("</ui>\n");
        String mabbrev = this.abbrev;
        if (mabbrev == null) {
            mabbrev = "";
        }
        xml.append(tab);
        xml.append("<abbrev>");
        xml.append(mabbrev);
        xml.append("</abbrev>\n");
        if (this.semTypeIds != null) {
            Iterator iter = this.semTypeIds.iterator();
            while (iter.hasNext()) {
                SemNetId id = (SemNetId)iter.next();
                id.xmlize(xml);
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String ui;
        if (!(c instanceof SemGroup)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        SemGroup comp = (SemGroup)c;
        boolean ret = true;
        String name = this.getName();
        if (!Str.compareStr(name, comp.getName())) {
            if (out != null) {
                out.println("this->Name='" + name + "' is different from '" + comp.getName() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(ui = this.getUI(), comp.getUI())) {
            if (out != null) {
                out.println("this->UI='" + ui + "' is different from '" + comp.getUI() + "'");
            }
            ret = false;
        }
        SemNetIdVector cstids = comp.getSemTypeIds();
        if (this.semTypeIds == null && cstids != null || this.semTypeIds != null && cstids == null) {
            ret = false;
        } else if (this.semTypeIds == null && cstids == null) {
            return ret;
        }
        if (!this.semTypeIds.equals(comp.getSemTypeIds())) {
            if (out != null) {
                out.println("this->SemTypeIds are different from comparison");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.name;
    }
}

