/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.units;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.sem.units.SemGroup;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class SemGroupVector
extends KSVector {
    public static final String XmlName = "SemGroupCollection";
    public static final String XmlStructure = "1.0";

    public SemGroupVector(Vector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public SemGroupVector(SemGroupVector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public SemGroupVector() {
        super(XmlName, XmlStructure);
    }

    public SemGroupVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "semGroup";
        List types = root.getChildren(childName, namespace);
        if (types == null || types.size() == 0) {
            return;
        }
        int i = 0;
        while (i < types.size()) {
            Element id = (Element)types.get(i);
            SemGroup semnetid = new SemGroup(id, namespace);
            if (semnetid == null) {
                throw new XMLException("Invalid semantic network id definition");
            }
            this.add(semnetid);
            ++i;
        }
    }

    public static SemGroupVector getInstance(String xml) {
        SemGroupVector aev = null;
        try {
            aev = new SemGroupVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public String xmlize(String release) {
        String oldRel = this.getRelease();
        this.setRelease(release);
        String xml = this.xmlize();
        this.setRelease(oldRel);
        return xml;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.sem.units.SemGroupVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            SemGroupVector vec = SemGroupVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No semantic types read");
                return;
            }
            System.out.println("Number of identifiers: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                SemGroup id = (SemGroup)iter.next();
                System.out.println("SemGroup----------------");
                id.output();
                System.out.println("SemGroup END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize(vec.getRelease()));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

