/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.units;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class SemNetId
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    public static final int SemanticType = 0;
    public static final int SemanticRelation = 1;
    private String name;
    private String ui;
    private int type;
    public static final String XmlName = "semnetId";

    public SemNetId() {
        this.name = "";
        this.ui = "";
        this.type = 0;
    }

    public SemNetId(Element semtype, Namespace namespace) throws XMLException {
        Element nameChild = semtype.getChild("name", namespace);
        if (nameChild == null) {
            throw new XMLException("No semantic type <name> found");
        }
        this.name = XMLInterpreter.extractString(nameChild);
        Element uiChild = semtype.getChild("ui", namespace);
        if (uiChild == null) {
            throw new XMLException("No semantic type <ui> found");
        }
        this.ui = XMLInterpreter.extractString(uiChild);
        Element stChild = semtype.getChild("semtype", namespace);
        if (stChild == null) {
            stChild = semtype.getChild("relation", namespace);
            if (stChild == null) {
                throw new XMLException("No semantic type <semtype> or relation <relation> found");
            }
            this.type = 1;
        } else {
            this.type = 0;
        }
    }

    public static SemNetId getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("semnetId must be the name of the first element");
            }
            return new SemNetId(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUI() {
        return this.ui;
    }

    public void setUI(String ui) {
        this.ui = ui;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type != 0 || type != 1 ? 0 : type;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("Semantic Network Identifier:   " + this.name);
        out.println("  UI:          " + this.ui);
        out.println("  Type:        " + this.type);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 200);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        String mname = this.name;
        if (mname == null) {
            mname = "";
        }
        xml.append(tab);
        xml.append("<name>");
        xml.append(Str.escape(mname));
        xml.append("</name>\n");
        String mui = this.ui;
        if (mui == null) {
            mui = "";
        }
        xml.append(tab);
        xml.append("<ui>");
        xml.append(mui);
        xml.append("</ui>\n");
        if (this.type == 0) {
            xml.append(tab);
            xml.append("<semtype/>\n");
        } else if (this.type == 1) {
            xml.append(tab);
            xml.append("<relation/>\n");
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String ui;
        if (!(c instanceof SemNetId)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        SemNetId comp = (SemNetId)c;
        boolean ret = true;
        String name = this.getName();
        if (!Str.compareStr(name, comp.getName())) {
            if (out != null) {
                out.println("this->Name='" + name + "' is different from '" + comp.getName() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(ui = this.getUI(), comp.getUI())) {
            if (out != null) {
                out.println("this->UI='" + ui + "' is different from '" + comp.getUI() + "'");
            }
            ret = false;
        }
        if (this.type != comp.getType()) {
            if (out != null) {
                out.println("this->Type='" + this.type + "' is different from '" + comp.getType() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.ui;
    }
}

