/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.lex;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class LexicalRecordsExecutor
extends QueryExecutor {
    public LexicalRecordsExecutor() {
    }

    public LexicalRecordsExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public LexicalRecordsExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getLexicalRecords")) {
            throw new XMLException("LexicalRecordsExecutor:Query is not a 'getLexicalRecords' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String tn = this.getTN(root, namespace);
            return this.retriever.getLexicalRecords(dbyear, tn);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

