/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class CUIExecutor
extends QueryExecutor {
    public CUIExecutor() {
    }

    public CUIExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public CUIExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("findCUI")) {
            throw new XMLException("CUIExecutor:Query is not a 'findCUI' query");
        }
        try {
            try {
                String dbyear = this.getRelease(root, namespace);
                String cn = this.getCN(root, namespace);
                Vector sabs = this.getSABS(root, namespace, false);
                String lat = this.getLAT(root, namespace, false);
                int manip = this.getManip(root, namespace);
                boolean incSupps = this.getIncSuppressibles(root, namespace);
                char[] result = this.retriever.findCUI(dbyear, cn, sabs, lat, manip, incSupps);
                return result;
            }
            catch (XMLException ex) {
                try {
                    String dbyear = this.getRelease(root, namespace);
                    String semtype = this.getSemType(root, namespace, true);
                    char[] result = this.retriever.findCUI(dbyear, semtype);
                    return result;
                }
                catch (XMLException ex2) {
                    try {
                        String dbyear = this.getRelease(root, namespace);
                        String sab = this.getSAB(root, namespace, true);
                        String scd = this.getSCD(root, namespace);
                        char[] result = this.retriever.findCUI(dbyear, sab, scd);
                        return result;
                    }
                    catch (XMLException ex3) {
                        String msg = "Either " + ex.getMessage() + ", " + ex2.getMessage() + ", or " + ex2.getMessage();
                        throw new XMLException(msg);
                    }
                }
            }
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

