/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class CooccurrencesExecutor
extends QueryExecutor {
    public CooccurrencesExecutor() {
    }

    public CooccurrencesExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public CooccurrencesExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getCooccurrences")) {
            throw new XMLException("CooccurrencesExecutor:Query is not a 'getCooccurrences' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String cui = this.getCUI(root, namespace);
            String lat = this.getLAT(root, namespace, false);
            String soc = this.getSAB(root, namespace, false);
            String coocType = this.getCOT(root, namespace);
            char[] result = this.retriever.getCooccurrences(dbyear, cui, lat, soc, coocType);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }

    public String getCOT(Element element, Namespace namespace) throws XMLException {
        Element coocType = element.getChild("coocType", namespace);
        if (coocType == null) {
            return "";
        }
        try {
            return XMLInterpreter.extractString(coocType);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }
}

