/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class DescribeSrcExecutor
extends QueryExecutor {
    public DescribeSrcExecutor() {
    }

    public DescribeSrcExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public DescribeSrcExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("describeSource")) {
            throw new XMLException("DescribeSrcExecutor:Query is not a 'describeSource' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            if (dbyear == null || dbyear.equals("")) {
                dbyear = this.retriever.getCurrentUMLSVersion();
            }
            String sab = this.getSAB(root, namespace, true);
            char[] result = this.retriever.describeSource(dbyear, sab);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

