/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class FindBasicConceptExecutor
extends QueryExecutor {
    public FindBasicConceptExecutor() {
    }

    public FindBasicConceptExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public FindBasicConceptExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("findBasicConcept")) {
            throw new XMLException("FindBasicConceptExecutor:Query is not a 'findBasicConcept' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String cn = this.getCN(root, namespace);
            Vector sabs = this.getSABS(root, namespace, false);
            String lat = this.getLAT(root, namespace, false);
            int manip = this.getManip(root, namespace);
            boolean incSupps = this.getIncSuppressibles(root, namespace);
            char[] result = this.retriever.findBasicConcept(dbyear, cn, sabs, lat, manip, incSupps);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

