/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class LocatorExecutor
extends QueryExecutor {
    public LocatorExecutor() {
    }

    public LocatorExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public LocatorExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        String rootName = root.getName();
        if (!rootName.equals("getLocator") && !rootName.equals("getLocators")) {
            throw new XMLException("LocatorExecutor:Query is not a 'getLocator' or 'getLocators' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String cui = this.getCUI(root, namespace);
            char[] result = this.retriever.getLocators(dbyear, cui);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

