/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class MeSHEntriesExecutor
extends QueryExecutor {
    public MeSHEntriesExecutor() {
    }

    public MeSHEntriesExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public MeSHEntriesExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getMeSHEntries")) {
            throw new XMLException("MeSHEntriesExecutor:Query is not a 'getMeSHEntries' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String tn = this.getTN(root, namespace, false);
            String cui = this.getCUI(root, namespace, false);
            if ((tn == null || tn.equals("")) && (cui == null || cui.equals(""))) {
                throw new XMLException("MeSHEntriesExecutor: one of the two arguments must be specified");
            }
            char[] result = this.retriever.getMeSHEntries(dbyear, cui, tn);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

