/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class MeSHInfoExecutor
extends QueryExecutor {
    public MeSHInfoExecutor() {
    }

    public MeSHInfoExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public MeSHInfoExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getMeSHInfo")) {
            throw new XMLException("MeSHInfoExecutor:Query is not a 'getMeSHInfo' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String dui = this.getDUI(root, namespace);
            char[] result = this.retriever.getMeSHInfo(dbyear, dui);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }

    public String getDUI(Element element, Namespace namespace) throws XMLException {
        Element dui = element.getChild("dui", namespace);
        if (dui == null) {
            return "";
        }
        try {
            return XMLInterpreter.extractString(dui);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }
}

