/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class RawRecordsExecutor
extends QueryExecutor {
    public RawRecordsExecutor() {
    }

    public RawRecordsExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public RawRecordsExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getRawRecords")) {
            throw new XMLException("RawRecordsExecutor:Query is not a 'getRawRecords' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String cui = this.getCUI(root, namespace);
            String lat = this.getLAT(root, namespace, false);
            String tableName = this.getTableName(root, namespace);
            char[] result = this.retriever.getRawRecords(dbyear, cui, lat, tableName);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }

    public String getTableName(Element element, Namespace namespace) throws XMLException {
        Element tableName = element.getChild("tableName", namespace);
        if (tableName == null) {
            throw new XMLException("<tableName> is a required field");
        }
        try {
            return XMLInterpreter.extractString(tableName);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }
}

