/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class RelationsExecutor
extends QueryExecutor {
    public RelationsExecutor() {
    }

    public RelationsExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public RelationsExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getRelations")) {
            throw new XMLException("RelationsExecutor:Query is not a 'getRelations' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String cui = this.getCUI(root, namespace);
            Vector sabs = this.getSABS(root, namespace, false);
            String lat = this.getLAT(root, namespace, false);
            String rel = this.getREL(root, namespace);
            char[] result = this.retriever.getRelations(dbyear, cui, sabs, lat, rel);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }

    public String getREL(Element element, Namespace namespace) throws XMLException {
        Element rel = element.getChild("rel", namespace);
        if (rel == null) {
            return "";
        }
        try {
            return XMLInterpreter.extractString(rel);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }
}

