/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class SpellingExecutor
extends QueryExecutor {
    public SpellingExecutor() {
    }

    public SpellingExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public SpellingExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("suggestSpelling")) {
            throw new XMLException("SpellingExecutor:Query is not a 'suggestSpelling' query");
        }
        try {
            String dict = this.getDict(root, namespace);
            String term = this.getTN(root, namespace);
            return this.retriever.suggestSpelling(dict, term);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }

    protected String getDict(Element element, Namespace namespace) throws XMLException {
        Element dictionary = element.getChild("dictionary", namespace);
        if (dictionary == null) {
            return "";
        }
        try {
            return XMLInterpreter.extractString(dictionary);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }
}

