/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class StringAttrsExecutor
extends QueryExecutor {
    public StringAttrsExecutor() {
    }

    public StringAttrsExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public StringAttrsExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getStringAttributes")) {
            throw new XMLException("StringAttrsExecutor:Query is not a 'getStringAttributes' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String cui = this.getCUI(root, namespace);
            String sab = this.getSAB(root, namespace, false);
            String attrName = this.getATN(root, namespace);
            char[] result = null;
            if (sab == null || sab.equals("")) {
                Vector sablist = this.getSABS(root, namespace, false);
                if (sablist.isEmpty()) {
                    sablist = null;
                }
                result = this.retriever.getStringAttributes(dbyear, cui, sablist, attrName);
            } else {
                result = this.retriever.getStringAttributes(dbyear, cui, sab, attrName);
            }
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }

    public String getATN(Element element, Namespace namespace) throws XMLException {
        Element attrName = element.getChild("attrName", namespace);
        if (attrName == null) {
            return "";
        }
        try {
            return XMLInterpreter.extractString(attrName);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }
}

