/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.sem;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.sem.SemQueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class ExistsAssocRelExecutor
extends SemQueryExecutor {
    public ExistsAssocRelExecutor() {
    }

    public ExistsAssocRelExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public ExistsAssocRelExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("existsAssociativeRelation")) {
            throw new XMLException("ExistsAssocRelExecutor:Query is not a 'existsAssociativeRelation' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            if (dbyear == null || dbyear.equals("")) {
                dbyear = this.retriever.getCurrentUMLSVersion();
            }
            String lhssemtype = this.getLHSSemType(root, namespace, true);
            String relation = this.getSemRelation(root, namespace, true);
            String rhssemtype = this.getRHSSemType(root, namespace, true);
            char[] result = this.retriever.existsAssociativeRelation(dbyear, lhssemtype, relation, rhssemtype);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

