/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.sem;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.Executor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class SemQueryExecutor
extends Executor {
    public SemQueryExecutor() {
    }

    public SemQueryExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public SemQueryExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public abstract char[] request(Element var1, Namespace var2) throws XMLException, DatabaseException;

    protected String getDBYear(Element element, Namespace namespace) throws XMLException {
        return this.getRelease(element, namespace);
    }

    protected String getRelease(Element element, Namespace namespace) throws XMLException {
        Element dbyear = element.getChild("dbyear", namespace);
        if (dbyear == null && (dbyear = element.getChild("release", namespace)) == null) {
            return "";
        }
        try {
            return XMLInterpreter.extractString(dbyear);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected boolean getTreeExpansion(Element element, Namespace namespace) throws XMLException {
        Element exp = element.getChild("expandTree", namespace);
        return exp != null;
    }

    protected String getContains(Element element, Namespace namespace) throws XMLException {
        Element exp = element.getChild("contains", namespace);
        if (exp == null) {
            throw new XMLException("The <contains/> element is required");
        }
        try {
            return XMLInterpreter.extractString(exp);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getSemType(Element element, Namespace namespace) throws XMLException {
        Element exp = element.getChild("semtype", namespace);
        if (exp == null) {
            throw new XMLException("The <semtype/> element is required");
        }
        try {
            return XMLInterpreter.extractString(exp);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getSemRelation(Element element, Namespace namespace, boolean required) throws XMLException {
        Element exp = element.getChild("semrel", namespace);
        if (exp == null) {
            if (required) {
                throw new XMLException("The <semrel/> element is required");
            }
            return null;
        }
        try {
            return XMLInterpreter.extractString(exp);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getLHSSemType(Element element, Namespace namespace, boolean required) throws XMLException {
        Element semtype = element.getChild("lhs_semtype", namespace);
        if (semtype == null) {
            if (required) {
                throw new XMLException("<lhs_semtype> is a required field");
            }
            return null;
        }
        try {
            return XMLInterpreter.extractString(semtype);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getRHSSemType(Element element, Namespace namespace, boolean required) throws XMLException {
        Element semtype = element.getChild("rhs_semtype", namespace);
        if (semtype == null) {
            if (required) {
                throw new XMLException("<rhs_semtype> is a required field");
            }
            return null;
        }
        try {
            return XMLInterpreter.extractString(semtype);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getLHSSemRelation(Element element, Namespace namespace, boolean required) throws XMLException {
        Element semrel = element.getChild("lhs_semrel", namespace);
        if (semrel == null) {
            if (required) {
                throw new XMLException("<lhs_semrel> is a required field");
            }
            return null;
        }
        try {
            return XMLInterpreter.extractString(semrel);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getRHSSemRelation(Element element, Namespace namespace, boolean required) throws XMLException {
        Element semrel = element.getChild("rhs_semrel", namespace);
        if (semrel == null) {
            if (required) {
                throw new XMLException("<rhs_semrel> is a required field");
            }
            return null;
        }
        try {
            return XMLInterpreter.extractString(semrel);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getSemGroup(Element element, Namespace namespace) throws XMLException {
        Element semgrp = element.getChild("semgroup", namespace);
        if (semgrp == null) {
            throw new XMLException("<semgroup> is a required field");
        }
        try {
            return XMLInterpreter.extractString(semgrp);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getTableName(Element element, Namespace namespace) throws XMLException {
        Element tableName = element.getChild("tableName", namespace);
        if (tableName == null) {
            throw new XMLException("<tableName> is a required field");
        }
        try {
            return XMLInterpreter.extractString(tableName);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getCUI(Element element, Namespace namespace) throws XMLException {
        Element cui = element.getChild("cui", namespace);
        if (cui == null) {
            throw new XMLException("<cui> is a required field");
        }
        try {
            return XMLInterpreter.extractString(cui);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }
}

