/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.sem;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.sem.SemQueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class SemRelAncsExecutor
extends SemQueryExecutor {
    public SemRelAncsExecutor() {
    }

    public SemRelAncsExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public SemRelAncsExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getSemRelationAncestors")) {
            throw new XMLException("SemRelAncsExecutor:Query is not a 'getSemRelationAncestors' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            if (dbyear == null || dbyear.equals("")) {
                dbyear = this.retriever.getCurrentUMLSVersion();
            }
            String semrel = this.getSemRelation(root, namespace, true);
            boolean expandTree = this.getTreeExpansion(root, namespace);
            char[] result = this.retriever.getSemRelationAncestors(dbyear, semrel, expandTree);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

