/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.torque;

import gov.nih.nlm.kss.torque.BaseKssUsersPeer;
import gov.nih.nlm.kss.torque.KssUsers;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.MimeUtility;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.resources.TurbineResources;

public class KssUsersPeer
extends BaseKssUsersPeer {
    public static List doSelectAll() throws Exception {
        Criteria crit = new Criteria();
        return BaseKssUsersPeer.doSelect(crit);
    }

    public static List doSelectForUsername(String username) throws Exception {
        Criteria crit = new Criteria();
        crit.add(BaseKssUsersPeer.USERNAME, (Object)username);
        return BaseKssUsersPeer.doSelect(crit);
    }

    public static KssUsers doSelectForUsernamePassword(String username, String password) throws Exception {
        KssUsers kss = null;
        Criteria crit = new Criteria();
        crit.add(BaseKssUsersPeer.USERNAME, (Object)username);
        crit.add(BaseKssUsersPeer.PASSWORD, (Object)password);
        List list = BaseKssUsersPeer.doSelect(crit);
        Iterator i = list.iterator();
        if (i.hasNext()) {
            kss = (KssUsers)i.next();
        }
        return kss;
    }

    public static List doSelectForUserId(int userid) throws Exception {
        Criteria crit = new Criteria();
        crit.add(BaseKssUsersPeer.USERID, userid);
        return BaseKssUsersPeer.doSelect(crit);
    }

    public static List doSelectForLicenseno(String licno) throws Exception {
        Criteria crit = new Criteria();
        crit.add(BaseKssUsersPeer.LICENSENO, (Object)licno);
        return BaseKssUsersPeer.doSelect(crit);
    }

    public static List doSelectForLicensenoAndUsername(String licno, String username) throws Exception {
        Criteria crit = new Criteria();
        crit.add(BaseKssUsersPeer.LICENSENO, (Object)licno);
        crit.add(BaseKssUsersPeer.USERNAME, (Object)username);
        return BaseKssUsersPeer.doSelect(crit);
    }

    public static int validateUser(KssUsers user, String password) {
        if (TurbineResources.getBoolean((String)"secure.passwords", (boolean)false)) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA");
                byte[] digest = md.digest(password.getBytes());
                byte[] digestPlus = new byte[digest.length + digest.length % 3];
                int i = 0;
                while (i < digest.length) {
                    digestPlus[i] = digest[i];
                    ++i;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(digestPlus.length);
                OutputStream encodedStream = MimeUtility.encode((OutputStream)baos, (String)"base64");
                encodedStream.write(digestPlus);
                password = baos.toString();
            }
            catch (Exception e) {
                BasePeer.log.error((Object)"Unable to validate encrypted password.", (Throwable)e);
                return 2;
            }
        }
        if (user != null) {
            if (user.getPassword() != null && user.getPassword().equals(password)) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public static boolean exists(String licenseno, String username) {
        List lst = null;
        try {
            lst = KssUsersPeer.doSelectForLicensenoAndUsername(licenseno, username);
        }
        catch (Exception e) {
            BasePeer.log.error((Object)e.getMessage());
            return false;
        }
        return lst.size() != 0;
    }

    public static boolean exists(String username) {
        List lst = null;
        try {
            lst = KssUsersPeer.doSelectForUsername(username);
        }
        catch (Exception e) {
            BasePeer.log.error((Object)e.getMessage());
            return false;
        }
        return lst.size() != 0;
    }

    public static KssUsers getUser(String username) {
        List lst = null;
        KssUsers kssu = null;
        try {
            lst = KssUsersPeer.doSelectForUsername(username);
        }
        catch (Exception e) {
            BasePeer.log.error((Object)e.getMessage());
        }
        Iterator iter = lst.iterator();
        while (iter.hasNext()) {
            kssu = (KssUsers)iter.next();
        }
        return kssu;
    }
}

