/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Properties;

public class Util {
    private static String MeSHQualifierFileProp = "KssMeshQualifierFile";
    private static String SourceFileProp = "KssSourceFile";
    private static String StringAttributesFileProp = "KssStringAttributesFile";

    public static boolean initializeProps(String fileName) {
        Properties props = System.getProperties();
        Properties kssprops = new Properties();
        try {
            FileInputStream is = new FileInputStream(fileName);
            kssprops.load(is);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Can't read the properties file ' " + fileName + "'. Make sure the file is in the CLASSPATH");
            return false;
        }
        catch (Exception e) {
            System.err.println("Can't read the properties file '" + fileName + "'. Make sure the file is in the CLASSPATH");
            return false;
        }
        Enumeration<?> propNames = kssprops.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propVal = kssprops.getProperty(propName);
            props.setProperty(propName, propVal);
        }
        System.setProperties(props);
        return true;
    }

    public static String getMeSHQualifierFileName() {
        String mqfn = System.getProperty(MeSHQualifierFileProp);
        if (mqfn == null) {
            return "";
        }
        return mqfn;
    }

    public static String getSourceFileName() {
        String sfn = System.getProperty(SourceFileProp);
        if (sfn == null) {
            return "";
        }
        return sfn;
    }

    public static String getStringAttributeFileName() {
        String sa = System.getProperty(StringAttributesFileProp);
        if (sa == null) {
            return "";
        }
        return sa;
    }

    private Util() {
    }
}

