/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Api;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.TXDocument;
import gov.nih.nlm.nls.lexCheck.Gram.CheckGrammer;
import gov.nih.nlm.nls.lexCheck.Lib.CatEntry;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.Convert;
import gov.nih.nlm.nls.lexCheck.Lib.InflectionalVar;
import gov.nih.nlm.nls.lexCheck.Lib.InflectionalVars;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ToJavaObjApi {
    public static Vector ToJavaObjs(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        Parser parser = new Parser(string);
        TXDocument tXDocument = parser.readStream(fileInputStream);
        if (parser.getNumberOfErrors() > 0) {
            return null;
        }
        Vector vector = ToJavaObjApi.GetLexRecords(tXDocument);
        return vector;
    }

    public static Vector ToJavaObjsFromText(String string) throws Exception {
        CheckSt checkSt = new CheckSt();
        CheckSt checkSt2 = new CheckSt(40);
        LineObject lineObject = new LineObject();
        String string2 = Convert.ToUnixLineSeparator(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        Vector vector = new Vector();
        while (lineObject != null) {
            if (lineObject.IsGoToNext()) {
                if (!stringTokenizer.hasMoreTokens()) break;
                lineObject.SetLine(stringTokenizer.nextToken());
                lineObject.IncreaseLineNum();
            }
            ToJavaObjApi.CheckLine(checkSt, checkSt2, lineObject, vector);
        }
        return vector;
    }

    public static LexRecord ToJavaObjFromText(String string) throws Exception {
        CheckSt checkSt = new CheckSt();
        CheckSt checkSt2 = new CheckSt(40);
        LineObject lineObject = new LineObject();
        String string2 = Convert.ToUnixLineSeparator(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        LexRecord lexRecord = new LexRecord();
        while (lineObject != null) {
            if (lineObject.IsGoToNext()) {
                if (!stringTokenizer.hasMoreTokens()) break;
                lineObject.SetLine(stringTokenizer.nextToken());
                lineObject.IncreaseLineNum();
            }
            lexRecord = ToJavaObjApi.CheckLine(checkSt, checkSt2, lineObject);
        }
        return lexRecord;
    }

    public static void main(String[] stringArray) {
        String string = "{base=bat\nentry=E0012112\n\tcat=noun\n\tvariants=reg\nsignature=vanni\n}";
        String string2 = "{base=molt\nspelling_variant=moult\nentry=E0040723\n\tcat=noun\n\tvariants=reg\nsignature=vanni\n}\n{base=molt\nspelling_variant=moult\nentry=E0040724\n\tcat=verb\n\tvariants=reg\n\tintran\n\ttran=np\n\tnominalization=molting|noun|E0412675\nsignature=vanni\n}";
        if (stringArray.length == 0) {
            try {
                LexRecord lexRecord;
                Vector vector = ToJavaObjApi.ToJavaObjsFromText(string2);
                int n = 0;
                while (n < vector.size()) {
                    lexRecord = (LexRecord)vector.elementAt(n);
                    System.out.println(lexRecord.GetText());
                    System.out.println("---------------------------------");
                    ++n;
                }
                lexRecord = ToJavaObjApi.ToJavaObjFromText(string2);
                System.out.println(lexRecord.GetText());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (stringArray.length == 1) {
            try {
                Vector vector = ToJavaObjApi.ToJavaObjs(stringArray[0]);
                if (vector.size() <= 0) {
                    System.exit(1);
                } else {
                    int n = 0;
                    while (n < vector.size()) {
                        LexRecord lexRecord = (LexRecord)vector.elementAt(n);
                        System.out.println(lexRecord.GetText());
                        System.out.println(lexRecord.GetXml());
                        System.out.println("---------------------------------");
                        InflectionalVars inflectionalVars = new InflectionalVars(lexRecord);
                        Vector vector2 = inflectionalVars.GetInflValues();
                        int n2 = 0;
                        while (n2 < vector2.size()) {
                            InflectionalVar inflectionalVar = (InflectionalVar)vector2.elementAt(n2);
                            System.out.println("unInfl: " + inflectionalVar.GetUnInfl() + "; infl: " + inflectionalVar.GetInflection() + "; var: " + inflectionalVar.GetVar());
                            ++n2;
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("*** Usage: java ToJavaObjApi filename.");
            System.exit(1);
        }
    }

    private static Vector GetLexRecords(Node node) throws Exception {
        Vector<LexRecord> vector = new Vector<LexRecord>();
        LexRecord lexRecord = null;
        CatEntry catEntry = null;
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getFirstChild();
            while (node3 != null) {
                if (node3.getNodeType() == 1) {
                    if (node3.getNodeName().equals("lexRecord")) {
                        lexRecord = new LexRecord();
                        ToJavaObjApi.GetLexRecord(node3, lexRecord, catEntry);
                    }
                    vector.addElement(lexRecord);
                }
                node3 = node3.getNextSibling();
            }
            node2 = node2.getNextSibling();
        }
        return vector;
    }

    private static void GetLexRecord(Node node, LexRecord lexRecord, CatEntry catEntry) throws Exception {
        if (node.getNodeType() == 1) {
            if (node.getNodeName().equals("base")) {
                lexRecord.SetBase(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("eui")) {
                lexRecord.SetEui(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("cat")) {
                lexRecord.SetCat(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("spellingVars")) {
                lexRecord.SetSpellingVar(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("acronyms")) {
                lexRecord.GetAcronyms().addElement(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("abbreviations")) {
                lexRecord.GetAbbreviations().addElement(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("annotations")) {
                lexRecord.GetAnnotations().addElement(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("signature")) {
                lexRecord.SetSignature(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("verbEntry")) {
                catEntry = ToJavaObjApi.getVerbValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("auxEntry")) {
                catEntry = ToJavaObjApi.getAuxValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("modalEntry")) {
                catEntry = ToJavaObjApi.getModalValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("nounEntry")) {
                catEntry = ToJavaObjApi.getNounValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("pronEntry")) {
                catEntry = ToJavaObjApi.getPronValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("adjEntry")) {
                catEntry = ToJavaObjApi.getAdjValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("advEntry")) {
                catEntry = ToJavaObjApi.getAdvValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("detEntry")) {
                catEntry = ToJavaObjApi.getDetValues(node);
                lexRecord.SetCatEntry(catEntry);
            }
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            ToJavaObjApi.GetLexRecord(node2, lexRecord, catEntry);
            node2 = node2.getNextSibling();
        }
    }

    private static CatEntry getVerbValues(Node node) {
        CatEntry catEntry = new CatEntry("verb");
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element) {
                if (node2.getNodeName().equals("variants")) {
                    catEntry.GetVerbEntry().GetVariants().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("intran")) {
                    catEntry.GetVerbEntry().GetIntran().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("tran")) {
                    catEntry.GetVerbEntry().GetTran().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("ditran")) {
                    catEntry.GetVerbEntry().GetDitran().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("link")) {
                    catEntry.GetVerbEntry().GetLink().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("cplxtran")) {
                    catEntry.GetVerbEntry().GetCplxtran().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("nominalization")) {
                    catEntry.GetVerbEntry().GetNominalization().addElement(ToJavaObjApi.getValue(node2));
                }
            }
            node2 = node2.getNextSibling();
        }
        return catEntry;
    }

    private static CatEntry getAuxValues(Node node) {
        CatEntry catEntry = new CatEntry("aux");
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element && node2.getNodeName().equals("variant")) {
                catEntry.GetAuxEntry().GetVariant().addElement(ToJavaObjApi.getValue(node2));
            }
            node2 = node2.getNextSibling();
        }
        return catEntry;
    }

    private static CatEntry getModalValues(Node node) {
        CatEntry catEntry = new CatEntry("modal");
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element && node2.getNodeName().equals("variant")) {
                catEntry.GetModalEntry().GetVariant().addElement(ToJavaObjApi.getValue(node2));
            }
            node2 = node2.getNextSibling();
        }
        return catEntry;
    }

    private static CatEntry getNounValues(Node node) {
        CatEntry catEntry = new CatEntry("noun");
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element) {
                if (node2.getNodeName().equals("variants")) {
                    catEntry.GetNounEntry().GetVariants().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("compl")) {
                    catEntry.GetNounEntry().GetCompl().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("nominalization")) {
                    catEntry.GetNounEntry().GetNominalization().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("tradeName")) {
                    catEntry.GetNounEntry().SetTradeName(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("trademark")) {
                    catEntry.GetNounEntry().SetTradeMark(true);
                } else if (node2.getNodeName().equals("proper")) {
                    catEntry.GetNounEntry().SetProper(true);
                }
            }
            node2 = node2.getNextSibling();
        }
        return catEntry;
    }

    private static CatEntry getPronValues(Node node) {
        CatEntry catEntry = new CatEntry("pron");
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element) {
                if (node2.getNodeName().equals("variants")) {
                    catEntry.GetPronEntry().GetVariants().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("type")) {
                    catEntry.GetPronEntry().GetType().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("gender")) {
                    catEntry.GetPronEntry().SetGender(ToJavaObjApi.getAttribute(node2, "type"));
                } else if (node2.getNodeName().equals("interrogative")) {
                    catEntry.GetPronEntry().SetInterrogative(true);
                }
            }
            node2 = node2.getNextSibling();
        }
        return catEntry;
    }

    private static CatEntry getDetValues(Node node) {
        CatEntry catEntry = new CatEntry("det");
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element) {
                if (node2.getNodeName().equals("variants")) {
                    catEntry.GetDetEntry().SetVariants(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("interrogative")) {
                    catEntry.GetDetEntry().SetInterrogative(true);
                } else if (node2.getNodeName().equals("demonstrative")) {
                    catEntry.GetDetEntry().SetDemonstrative(true);
                }
            }
            node2 = node2.getNextSibling();
        }
        return catEntry;
    }

    private static CatEntry getAdvValues(Node node) {
        CatEntry catEntry = new CatEntry("adv");
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element) {
                if (node2.getNodeName().equals("variants")) {
                    catEntry.GetAdvEntry().GetVariants().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("modification")) {
                    catEntry.GetAdvEntry().GetModification().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("negative")) {
                    catEntry.GetAdvEntry().SetNegative(ToJavaObjApi.getAttribute(node2, "type"));
                } else if (node2.getNodeName().equals("interrogative")) {
                    catEntry.GetAdvEntry().SetInterrogative(true);
                }
            }
            node2 = node2.getNextSibling();
        }
        return catEntry;
    }

    private static CatEntry getAdjValues(Node node) {
        CatEntry catEntry = new CatEntry("adj");
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element) {
                if (node2.getNodeName().equals("variants")) {
                    catEntry.GetAdjEntry().GetVariants().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("position")) {
                    catEntry.GetAdjEntry().GetPosition().addElement(ToJavaObjApi.getAttribute(node2, "type"));
                } else if (node2.getNodeName().equals("compl")) {
                    catEntry.GetAdjEntry().GetCompl().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("nominalization")) {
                    catEntry.GetAdjEntry().GetNominalization().addElement(ToJavaObjApi.getValue(node2));
                } else if (node2.getNodeName().equals("stative")) {
                    catEntry.GetAdjEntry().SetStative(true);
                }
            }
            node2 = node2.getNextSibling();
        }
        return catEntry;
    }

    private static String getValue(Node node) {
        String string = null;
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element || node2 instanceof EntityReference) {
                ToJavaObjApi.getValue(node2);
            } else if (node2 instanceof Text) {
                string = node2.getNodeValue();
            }
            node2 = node2.getNextSibling();
        }
        return string;
    }

    private static String getAttribute(Node node, String string) {
        Node node2;
        String string2 = new String();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.getLength() == 1 && (node2 = namedNodeMap.item(0)).getNodeName().equals(string)) {
            string2 = node2.getNodeValue();
        }
        return string2;
    }

    private static Vector getAttributes(Node node) {
        Vector<String> vector = new Vector<String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node2 = namedNodeMap.item(n);
            if (node2.getNodeName().equals("type")) {
                vector.addElement(node2.getNodeValue());
            }
            ++n;
        }
        return vector;
    }

    private static void CheckLine(CheckSt checkSt, CheckSt checkSt2, LineObject lineObject, Vector vector) {
        boolean bl = false;
        boolean bl2 = true;
        bl = CheckGrammer.Check(lineObject, bl2, checkSt, checkSt2, false);
        if (checkSt.GetCurState() == 10 && bl) {
            vector.add(CheckGrammer.GetLexRecord());
        }
    }

    private static LexRecord CheckLine(CheckSt checkSt, CheckSt checkSt2, LineObject lineObject) {
        boolean bl = false;
        boolean bl2 = true;
        bl = CheckGrammer.Check(lineObject, bl2, checkSt, checkSt2, false);
        LexRecord lexRecord = new LexRecord();
        if (checkSt.GetCurState() == 10 && bl) {
            lexRecord = CheckGrammer.GetLexRecord();
        }
        return lexRecord;
    }
}

