/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Adj;

import gov.nih.nlm.nls.lexCheck.Compl.CheckAsComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckFinComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckInfComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckPphr;
import gov.nih.nlm.nls.lexCheck.Compl.CheckWhinfComp;
import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;

public class CheckFormatAdjCompl
implements CheckFormat {
    private static final int LEGAL_FILLER_NUM = 8;
    private static HashSet filler_ = new HashSet(8);

    public boolean IsLegalFormat(String string) {
        boolean bl = false;
        if (filler_.contains(string)) {
            bl = true;
        } else if (string.startsWith("ascomp:")) {
            bl = CheckAsComp.IsLegal(string);
        } else if (string.startsWith("fincomp(")) {
            bl = CheckFinComp.IsLegal(string);
        } else if (string.startsWith("infcomp:")) {
            bl = CheckInfComp.IsLegal(string);
        } else if (string.startsWith("pphr(")) {
            bl = CheckPphr.IsLegal(string);
        } else if (!string.startsWith("binfcomp:")) {
            bl = string.startsWith("whinfcomp:") ? CheckWhinfComp.IsLegal(string) : false;
        }
        return bl;
    }

    static {
        filler_.add("advbl");
        filler_.add("ascomp:");
        filler_.add("fincomp(");
        filler_.add("infcomp:");
        filler_.add("pphr");
        filler_.add("binfcomp:");
        filler_.add("whfincomp");
        filler_.add("whinfcomp:");
    }
}

