/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Verb;

import gov.nih.nlm.nls.lexCheck.Compl.CheckFinComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckIngComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckNpComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckParticle;
import gov.nih.nlm.nls.lexCheck.Compl.CheckPphr;
import gov.nih.nlm.nls.lexCheck.Compl.CheckWhfinComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckWhinfComp;
import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;

public class CheckFormatVerbDitran
implements CheckFormat {
    private static final int LEGAL_FILLER1_NUM = 1;
    private static HashSet filler1_ = new HashSet(1);
    private static final int LEGAL_FILLER2_NUM = 2;
    private static HashSet filler2_ = new HashSet(2);

    public boolean IsLegalFormat(String string) {
        boolean bl = false;
        int n = string.indexOf(";part(");
        int n2 = string.indexOf(";nopass");
        int n3 = string.indexOf(";datmvt");
        int n4 = string.indexOf(";noprtmvt");
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = n2 != -1 ? string.substring(n, n2) : (n3 != -1 ? string.substring(n, n3) : (n4 != -1 ? string.substring(n, n4) : string.substring(n)));
        } else {
            string2 = n2 != -1 ? string.substring(0, n2) : (n3 != -1 ? string.substring(0, n3) : (n4 != -1 ? string.substring(0, n4) : string));
        }
        bl = string3 != null ? this.CheckDitranFiller(string2) && CheckParticle.IsLegal(string3) : this.CheckDitranFiller(string2);
        return bl;
    }

    private boolean CheckDitranFiller(String string) {
        boolean bl = false;
        String string2 = new String();
        String string3 = new String();
        if (string.startsWith("pphr(")) {
            int n = string.indexOf("),");
            string2 = string.substring(0, n + 1);
            string3 = string.substring(n + 2);
        } else {
            int n = string.indexOf(",");
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        bl = this.CheckFiller1(string2) && this.CheckFiller2(string3);
        return bl;
    }

    private boolean CheckFiller1(String string) {
        boolean bl = false;
        if (filler1_.contains(string)) {
            bl = true;
        } else if (string.startsWith("fincomp(")) {
            bl = CheckFinComp.IsLegal(string);
        } else if (string.startsWith("ingcomp:")) {
            bl = CheckIngComp.IsLegal(string);
        } else if (string.startsWith("np|")) {
            bl = CheckNpComp.IsLegal(string);
        } else if (string.startsWith("pphr(")) {
            bl = CheckPphr.IsLegal(string);
        }
        return bl;
    }

    private boolean CheckFiller2(String string) {
        boolean bl = false;
        if (filler2_.contains(string)) {
            bl = true;
        } else if (string.startsWith("fincomp(")) {
            bl = CheckFinComp.IsLegal(string);
        } else if (string.startsWith("np|")) {
            bl = CheckNpComp.IsLegal(string);
        } else if (string.startsWith("pphr(")) {
            bl = CheckPphr.IsLegal(string);
        } else if (string.startsWith("whfincomp:")) {
            bl = CheckWhfinComp.IsLegal(string);
        } else if (string.startsWith("whinfcomp:")) {
            bl = CheckWhinfComp.IsLegal(string);
        }
        return bl;
    }

    static {
        filler1_.add("np");
        filler2_.add("np");
        filler2_.add("whfincomp");
    }
}

