/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.Convert;
import gov.nih.nlm.nls.lexCheck.Lib.InflectionalVar;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;

public class InflectionalVars {
    private LexRecord lexRecord_ = null;
    private Vector inflValues_ = new Vector();
    private static HashSet inflections_ = new HashSet();
    private static HashSet consonants_ = new HashSet();
    private static HashSet vowels_ = new HashSet();
    private static HashSet eioySets_ = new HashSet();

    public InflectionalVars(LexRecord lexRecord) {
        this.lexRecord_ = lexRecord;
        String string = lexRecord.GetBase();
        String string2 = lexRecord.GetEui();
        String string3 = lexRecord.GetCategory();
        this.GetInflVars(string, string2, string3, string);
        Vector vector = lexRecord.GetSpellingVars();
        int n = 0;
        while (n < vector.size()) {
            String string4 = (String)vector.elementAt(n);
            this.GetInflVars(string4, string2, string3, string);
            ++n;
        }
    }

    public static String GetXml(LexRecord lexRecord) {
        InflectionalVars inflectionalVars = new InflectionalVars(lexRecord);
        String string = new String();
        Vector vector = inflectionalVars.GetInflValues();
        int n = 0;
        while (n < vector.size()) {
            InflectionalVar inflectionalVar = (InflectionalVar)vector.elementAt(n);
            String string2 = new String();
            if (inflectionalVar.GetType() != null) {
                string2 = " type=\"" + inflectionalVar.GetType() + "\"";
            }
            string = string + "\t<inflVars cit=\"" + Convert.ToNumericEntity(inflectionalVar.GetCit()) + "\" unInfl=\"" + Convert.ToNumericEntity(inflectionalVar.GetUnInfl()) + "\" eui=\"" + inflectionalVar.GetEui() + "\" cat=\"" + inflectionalVar.GetCat() + "\" infl=\"" + inflectionalVar.GetInflection() + "\"" + string2 + ">" + Convert.ToNumericEntity(inflectionalVar.GetVar()) + "</inflVars>\n";
            ++n;
        }
        return string;
    }

    public Vector GetInflValues() {
        return this.inflValues_;
    }

    private void GetInflVars(String string, String string2, String string3, String string4) {
        if (string3.equals("verb")) {
            this.GetVerbInflVars(string, string2, string3, string4);
        } else if (string3.equals("noun")) {
            this.GetNounInflVars(string, string2, string3, string4);
        } else if (string3.equals("adj")) {
            this.GetAdjInflVars(string, string2, string3, string4);
        } else if (string3.equals("adv")) {
            this.GetAdvInflVars(string, string2, string3, string4);
        } else if (string3.equals("aux")) {
            this.GetAuxInflVars(string, string2, string3, string4);
        } else if (string3.equals("modal")) {
            this.GetModalInflVars(string, string2, string3, string4);
        } else if (string3.equals("pron")) {
            this.GetPronInflVars(string, string2, string3, string4);
        } else if (string3.equals("det")) {
            this.GetDetInflVars(string, string2, string3, string4);
        } else if (string3.equals("prep")) {
            this.GetPrepInflVars(string, string2, string3, string4);
        } else if (string3.equals("compl")) {
            this.GetComplInflVars(string, string2, string3, string4);
        } else if (string3.equals("conj")) {
            this.GetConjInflVars(string, string2, string3, string4);
        }
    }

    private void GetVerbInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
        this.inflValues_.addElement(new InflectionalVar(string2, string, "pres1p23p", string, string3, string4));
        InflectionalVar inflectionalVar = new InflectionalVar(string2, string, "infinitive", string, string3, string4);
        Vector vector = this.lexRecord_.GetCatEntry().GetVerbEntry().GetVariants();
        int n = 0;
        while (n < vector.size()) {
            InflectionalVar inflectionalVar2;
            InflectionalVar inflectionalVar3;
            InflectionalVar inflectionalVar4;
            Object object;
            String string5;
            String string6 = (String)vector.elementAt(n);
            if (string6.startsWith("regd")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                string5 = "regd";
                char c = this.GetLastChar(string);
                char c2 = this.GetLast2Char(string);
                String string7 = new Character(c2).toString();
                object = null;
                object = string.endsWith("s") || string.endsWith("z") || string.endsWith("x") || string.endsWith("ch") || string.endsWith("sh") ? new InflectionalVar(string2, string, string5, "pres3s", string + "es", string3, string4) : (string.endsWith("ie") ? new InflectionalVar(string2, string, string5, "pres3s", string + "s", string3, string4) : (string.endsWith("ee") || string.endsWith("oe") || string.endsWith("ye") ? new InflectionalVar(string2, string, string5, "pres3s", string + "s", string3, string4) : (string.endsWith("y") && consonants_.contains(string7) ? new InflectionalVar(string2, string, string5, "pres3s", string.substring(0, string.length() - 1) + "ies", string3, string4) : (string.endsWith("e") && !eioySets_.contains(string7) ? new InflectionalVar(string2, string, string5, "pres3s", string + "s", string3, string4) : new InflectionalVar(string2, string, string5, "pres3s", string + "s", string3, string4)))));
                ((InflectionalVar)object).SetUnique(this.IsUnique(this.inflValues_, (InflectionalVar)object));
                this.inflValues_.addElement(object);
                this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "past", string + c + "ed", string3, string4));
                this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "pastPart", string + c + "ed", string3, string4));
                this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "presPart", string + c + "ing", string3, string4));
            } else if (string6.startsWith("reg")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                string5 = "reg";
                char c = this.GetLastChar(string);
                char c3 = this.GetLast2Char(string);
                String string8 = new Character(c3).toString();
                object = null;
                inflectionalVar4 = null;
                inflectionalVar3 = null;
                inflectionalVar2 = null;
                if (string.endsWith("s") || string.endsWith("z") || string.endsWith("x") || string.endsWith("ch") || string.endsWith("sh")) {
                    object = new InflectionalVar(string2, string, string5, "pres3s", string + "es", string3, string4);
                    inflectionalVar4 = new InflectionalVar(string2, string, string5, "past", string + "ed", string3, string4);
                    inflectionalVar3 = new InflectionalVar(string2, string, string5, "pastPart", string + "ed", string3, string4);
                    inflectionalVar2 = new InflectionalVar(string2, string, string5, "presPart", string + "ing", string3, string4);
                } else if (string.endsWith("ie")) {
                    object = new InflectionalVar(string2, string, string5, "pres3s", string + "s", string3, string4);
                    inflectionalVar4 = new InflectionalVar(string2, string, string5, "past", string + "d", string3, string4);
                    inflectionalVar3 = new InflectionalVar(string2, string, string5, "pastPart", string + "d", string3, string4);
                    inflectionalVar2 = new InflectionalVar(string2, string, string5, "presPart", string.substring(0, string.length() - 2) + "ying", string3, string4);
                } else if (string.endsWith("ee") || string.endsWith("oe") || string.endsWith("ye")) {
                    object = new InflectionalVar(string2, string, string5, "pres3s", string + "s", string3, string4);
                    inflectionalVar4 = new InflectionalVar(string2, string, string5, "past", string + "d", string3, string4);
                    inflectionalVar3 = new InflectionalVar(string2, string, string5, "pastPart", string + "d", string3, string4);
                    inflectionalVar2 = new InflectionalVar(string2, string, string5, "presPart", string + "ing", string3, string4);
                } else if (string.endsWith("y") && consonants_.contains(string8)) {
                    object = new InflectionalVar(string2, string, string5, "pres3s", string.substring(0, string.length() - 1) + "ies", string3, string4);
                    inflectionalVar4 = new InflectionalVar(string2, string, string5, "past", string.substring(0, string.length() - 1) + "ied", string3, string4);
                    inflectionalVar3 = new InflectionalVar(string2, string, string5, "pastPart", string.substring(0, string.length() - 1) + "ied", string3, string4);
                    inflectionalVar2 = new InflectionalVar(string2, string, string5, "presPart", string + "ing", string3, string4);
                } else if (string.endsWith("e") && !eioySets_.contains(string8)) {
                    object = new InflectionalVar(string2, string, string5, "pres3s", string + "s", string3, string4);
                    inflectionalVar4 = new InflectionalVar(string2, string, string5, "past", string + "d", string3, string4);
                    inflectionalVar3 = new InflectionalVar(string2, string, string5, "pastPart", string + "d", string3, string4);
                    inflectionalVar2 = new InflectionalVar(string2, string, string5, "presPart", string.substring(0, string.length() - 1) + "ing", string3, string4);
                } else {
                    object = new InflectionalVar(string2, string, string5, "pres3s", string + "s", string3, string4);
                    inflectionalVar4 = new InflectionalVar(string2, string, string5, "past", string + "ed", string3, string4);
                    inflectionalVar3 = new InflectionalVar(string2, string, string5, "pastPart", string + "ed", string3, string4);
                    inflectionalVar2 = new InflectionalVar(string2, string, string5, "presPart", string + "ing", string3, string4);
                }
                ((InflectionalVar)object).SetUnique(this.IsUnique(this.inflValues_, (InflectionalVar)object));
                inflectionalVar4.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar4));
                inflectionalVar3.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar3));
                inflectionalVar2.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar2));
                this.inflValues_.addElement(object);
                this.inflValues_.addElement(inflectionalVar4);
                this.inflValues_.addElement(inflectionalVar3);
                this.inflValues_.addElement(inflectionalVar2);
            } else if (string6.startsWith("irreg")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                string5 = "|";
                StringTokenizer stringTokenizer = new StringTokenizer(string6, string5, true);
                String string9 = stringTokenizer.nextToken();
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).equals(string5)) {
                        ++n2;
                        continue;
                    }
                    switch (n2) {
                        case 1: {
                            inflectionalVar4 = new InflectionalVar(string2, string, string9, "pres3s", (String)object, string3, string4);
                            inflectionalVar4.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar4));
                            this.inflValues_.addElement(inflectionalVar4);
                            break;
                        }
                        case 2: {
                            inflectionalVar3 = new InflectionalVar(string2, string, string9, "past", (String)object, string3, string4);
                            inflectionalVar3.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar3));
                            this.inflValues_.addElement(inflectionalVar3);
                            break;
                        }
                        case 3: {
                            inflectionalVar2 = new InflectionalVar(string2, string, string9, "pastPart", (String)object, string3, string4);
                            inflectionalVar2.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar2));
                            this.inflValues_.addElement(inflectionalVar2);
                            break;
                        }
                        case 4: {
                            InflectionalVar inflectionalVar5 = new InflectionalVar(string2, string, string9, "presPart", (String)object, string3, string4);
                            inflectionalVar5.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar5));
                            this.inflValues_.addElement(inflectionalVar5);
                        }
                    }
                }
            }
            ++n;
        }
    }

    private void GetNounInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
        InflectionalVar inflectionalVar = new InflectionalVar(string2, string, "singular", string, string3, string4);
        Vector vector = this.lexRecord_.GetCatEntry().GetNounEntry().GetVariants();
        int n = 0;
        while (n < vector.size()) {
            Object object;
            Object object2;
            String string5 = (String)vector.elementAt(n);
            if (string5.startsWith("reg")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                char c = this.GetLastChar(string);
                char c2 = this.GetLast2Char(string);
                object2 = new Character(c2).toString();
                object = null;
                object = c == 'y' && consonants_.contains(object2) ? new InflectionalVar(string2, string, "reg", "plural", string.substring(0, string.length() - 1) + "ies", string3, string4) : (string.endsWith("s") || string.endsWith("z") || string.endsWith("x") || string.endsWith("ch") || string.endsWith("sh") ? new InflectionalVar(string2, string, "reg", "plural", string + "es", string3, string4) : new InflectionalVar(string2, string, "reg", "plural", string + "s", string3, string4));
                ((InflectionalVar)object).SetUnique(this.IsUnique(this.inflValues_, (InflectionalVar)object));
                this.inflValues_.addElement(object);
            } else if (string5.startsWith("glreg")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                if (string.endsWith("us")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string.substring(0, string.length() - 2) + "i", string3, string4));
                } else if (string.endsWith("ma")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string + "ta", string3, string4));
                } else if (string.endsWith("a")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string + "e", string3, string4));
                } else if (string.endsWith("um")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string.substring(0, string.length() - 2) + "a", string3, string4));
                } else if (string.endsWith("on")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string.substring(0, string.length() - 2) + "a", string3, string4));
                } else if (string.endsWith("sis")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string.substring(0, string.length() - 2) + "es", string3, string4));
                } else if (string.endsWith("is")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string.substring(0, string.length() - 1) + "des", string3, string4));
                } else if (string.endsWith("men")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string.substring(0, string.length() - 2) + "ina", string3, string4));
                } else if (string.endsWith("ex")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string.substring(0, string.length() - 2) + "ices", string3, string4));
                } else if (string.endsWith("x")) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, "glreg", "plural", string.substring(0, string.length() - 1) + "ces", string3, string4));
                }
            } else if (string5.startsWith("metareg")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                InflectionalVar inflectionalVar2 = new InflectionalVar(string2, string, "metareg", "plural", string + "s", string3, string4);
                inflectionalVar2.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar2));
                this.inflValues_.addElement(inflectionalVar2);
                InflectionalVar inflectionalVar3 = new InflectionalVar(string2, string, "metareg", "plural", string + "'s", string3, string4);
                inflectionalVar3.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar3));
                this.inflValues_.addElement(inflectionalVar3);
            } else if (string5.startsWith("irreg")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                String string6 = "|";
                StringTokenizer stringTokenizer = new StringTokenizer(string5, string6);
                object2 = stringTokenizer.nextToken();
                object = new InflectionalVar(string2, string, (String)object2, "plural", stringTokenizer.nextToken(), string3, string4);
                ((InflectionalVar)object).SetUnique(this.IsUnique(this.inflValues_, (InflectionalVar)object));
                this.inflValues_.addElement(object);
            } else if (string5.startsWith("sing")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
            } else if (string5.startsWith("plur")) {
                InflectionalVar inflectionalVar4 = new InflectionalVar(string2, string, "plur", "plural", string, string3, string4);
                inflectionalVar4.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar4));
                this.inflValues_.addElement(inflectionalVar4);
            } else if (string5.startsWith("inv")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                InflectionalVar inflectionalVar5 = new InflectionalVar(string2, string, "inv", "plural", string, string3, string4);
                inflectionalVar5.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar5));
                this.inflValues_.addElement(inflectionalVar5);
            } else if (string5.startsWith("uncount")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
            } else if (string5.startsWith("groupuncount")) {
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                InflectionalVar inflectionalVar6 = new InflectionalVar(string2, string, "groupuncount", "plural", string, string3, string4);
                inflectionalVar6.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar6));
                this.inflValues_.addElement(inflectionalVar6);
            } else if (string5.startsWith("group(")) {
                InflectionalVar inflectionalVar7;
                String string7;
                if (!this.inflValues_.contains(inflectionalVar)) {
                    this.inflValues_.addElement(inflectionalVar);
                }
                InflectionalVar inflectionalVar8 = new InflectionalVar(string2, string, string5, "plural", string, string3, string4);
                inflectionalVar8.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar8));
                if (!this.inflValues_.contains(inflectionalVar8)) {
                    this.inflValues_.addElement(inflectionalVar8);
                }
                String string8 = " ()";
                object2 = new StringTokenizer(string5, string8);
                object = ((StringTokenizer)object2).nextToken();
                String string9 = ((StringTokenizer)object2).nextToken();
                if (string9.equals("reg")) {
                    char c = this.GetLastChar(string);
                    char c3 = this.GetLast2Char(string);
                    string7 = new Character(c3).toString();
                    inflectionalVar7 = null;
                    inflectionalVar7 = c == 'y' && consonants_.contains(string7) ? new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 1) + "ies", string3, string4) : (string.endsWith("s") || string.endsWith("z") || string.endsWith("x") || string.endsWith("ch") || string.endsWith("sh") ? new InflectionalVar(string2, string, string5, "plural", string + "es", string3, string4) : new InflectionalVar(string2, string, string5, "plural", string + "s", string3, string4));
                    inflectionalVar7.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar7));
                    this.inflValues_.addElement(inflectionalVar7);
                } else if (string9.equals("glreg")) {
                    if (string.endsWith("us")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 2) + "i", string3, string4));
                    } else if (string.endsWith("ma")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string + "ta", string3, string4));
                    } else if (string.endsWith("a")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string + "e", string3, string4));
                    } else if (string.endsWith("um")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 2) + "a", string3, string4));
                    } else if (string.endsWith("on")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 2) + "a", string3, string4));
                    } else if (string.endsWith("sis")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 2) + "es", string3, string4));
                    } else if (string.endsWith("is")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 1) + "des", string3, string4));
                    } else if (string.endsWith("men")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 2) + "ina", string3, string4));
                    } else if (string.endsWith("ex")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 2) + "ices", string3, string4));
                    } else if (string.endsWith("x")) {
                        this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "plural", string.substring(0, string.length() - 1) + "ces", string3, string4));
                    }
                } else if (string9.equals("metareg")) {
                    InflectionalVar inflectionalVar9 = new InflectionalVar(string2, string, string5, "plural", string + "s", string3, string4);
                    inflectionalVar9.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar9));
                    this.inflValues_.addElement(inflectionalVar9);
                    InflectionalVar inflectionalVar10 = new InflectionalVar(string2, string, string5, "plural", string + "'s", string3, string4);
                    inflectionalVar10.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar10));
                    this.inflValues_.addElement(inflectionalVar10);
                } else if (string9.startsWith("irreg")) {
                    String string10 = "|";
                    StringTokenizer stringTokenizer = new StringTokenizer(string9, string10);
                    string7 = stringTokenizer.nextToken();
                    inflectionalVar7 = new InflectionalVar(string2, string, string5, "plural", stringTokenizer.nextToken(), string3, string4);
                    inflectionalVar7.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar7));
                    this.inflValues_.addElement(inflectionalVar7);
                }
            }
            ++n;
        }
    }

    private void GetAdjInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
        InflectionalVar inflectionalVar = new InflectionalVar(string2, string, "positive", string, string3, string4);
        this.inflValues_.addElement(inflectionalVar);
        Vector vector = this.lexRecord_.GetCatEntry().GetAdjEntry().GetVariants();
        int n = 0;
        while (n < vector.size()) {
            Object object;
            String string5;
            String string6 = (String)vector.elementAt(n);
            if (string6.startsWith("irreg")) {
                string5 = "|";
                StringTokenizer stringTokenizer = new StringTokenizer(string6, string5);
                String string7 = stringTokenizer.nextToken();
                object = new InflectionalVar(string2, string, string7, "comparative", stringTokenizer.nextToken(), string3, string4);
                ((InflectionalVar)object).SetUnique(this.IsUnique(this.inflValues_, (InflectionalVar)object));
                this.inflValues_.addElement(object);
                InflectionalVar inflectionalVar2 = new InflectionalVar(string2, string, string7, "superlative", stringTokenizer.nextToken(), string3, string4);
                inflectionalVar2.SetUnique(this.IsUnique(this.inflValues_, inflectionalVar2));
                this.inflValues_.addElement(inflectionalVar2);
            } else if (string6.startsWith("regd")) {
                string5 = "regd";
                char c = this.GetLastChar(string);
                this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "comparative", string + c + "er", string3, string4));
                this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "superlative", string + c + "est", string3, string4));
            } else if (string6.startsWith("reg")) {
                string5 = "reg";
                char c = this.GetLastChar(string);
                char c2 = this.GetLast2Char(string);
                object = new Character(c2).toString();
                if (c == 'y' && consonants_.contains(object)) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "comparative", string.substring(0, string.length() - 1) + "ier", string3, string4));
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "superlative", string.substring(0, string.length() - 1) + "iest", string3, string4));
                } else if (c == 'e') {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "comparative", string + "r", string3, string4));
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "superlative", string + "st", string3, string4));
                } else {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "comparative", string + "er", string3, string4));
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "superlative", string + "est", string3, string4));
                }
            }
            ++n;
        }
    }

    private void GetAdvInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
        InflectionalVar inflectionalVar = new InflectionalVar(string2, string, "positive", string, string3, string4);
        this.inflValues_.addElement(inflectionalVar);
        Vector vector = this.lexRecord_.GetCatEntry().GetAdvEntry().GetVariants();
        int n = 0;
        while (n < vector.size()) {
            String string5;
            String string6 = (String)vector.elementAt(n);
            if (string6.startsWith("irreg")) {
                string5 = "|";
                StringTokenizer stringTokenizer = new StringTokenizer(string6, string5);
                String string7 = stringTokenizer.nextToken();
                this.inflValues_.addElement(new InflectionalVar(string2, string, string7, "comparative", stringTokenizer.nextToken(), string3, string4));
                this.inflValues_.addElement(new InflectionalVar(string2, string, string7, "superlative", stringTokenizer.nextToken(), string3, string4));
            } else if (string6.startsWith("reg")) {
                string5 = "reg";
                char c = this.GetLastChar(string);
                char c2 = this.GetLast2Char(string);
                String string8 = new Character(c2).toString();
                if (c == 'y' && consonants_.contains(string8)) {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "comparative", string.substring(0, string.length() - 1) + "ier", string3, string4));
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "superlative", string.substring(0, string.length() - 1) + "iest", string3, string4));
                } else if (c == 'e') {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "comparative", string + "r", string3, string4));
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "superlative", string + "st", string3, string4));
                } else {
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "comparative", string + "er", string3, string4));
                    this.inflValues_.addElement(new InflectionalVar(string2, string, string5, "superlative", string + "est", string3, string4));
                }
            }
            ++n;
        }
    }

    private char GetLastChar(String string) {
        int n = string.length();
        char c = string.toLowerCase().charAt(n - 1);
        return c;
    }

    private char GetLast2Char(String string) {
        int n = string.length();
        char c = string.toLowerCase().charAt(n - 2);
        return c;
    }

    private void GetAuxInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
        Vector vector = this.lexRecord_.GetCatEntry().GetAuxEntry().GetVariant();
        int n = 0;
        while (n < vector.size()) {
            String string5 = (String)vector.elementAt(n);
            int n2 = string5.indexOf(";");
            String string6 = string5.substring(0, n2);
            String string7 = this.MapToInflection(string5.substring(n2 + 1));
            this.inflValues_.addElement(new InflectionalVar(string2, string, "reg", string7, string6, string3, string4));
            ++n;
        }
    }

    private void GetModalInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
        this.inflValues_.addElement(new InflectionalVar(string2, string, "pres", string, string3, string4));
        Vector vector = this.lexRecord_.GetCatEntry().GetModalEntry().GetVariant();
        int n = 0;
        while (n < vector.size()) {
            String string5 = (String)vector.elementAt(n);
            int n2 = string5.indexOf(";");
            String string6 = string5.substring(0, n2);
            String string7 = this.MapToInflection(string5.substring(n2 + 1));
            this.inflValues_.addElement(new InflectionalVar(string2, string, "reg", string7, string6, string3, string4));
            ++n;
        }
    }

    private String MapToInflection(String string) {
        String string2 = " (,):";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = new String();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("past")) {
                string3 = string3 + "past";
                continue;
            }
            if (string4.equals("pres")) {
                string3 = string3 + "pres";
                continue;
            }
            if (string4.equals("past_part")) {
                string3 = string3 + "pastPart";
                continue;
            }
            if (string4.equals("pres_part")) {
                string3 = string3 + "presPart";
                continue;
            }
            if (string4.equals("infinitive")) {
                string3 = string3 + "infinitive";
                continue;
            }
            if (string4.equals("negative")) {
                string3 = string3 + "Neg";
                continue;
            }
            if (string4.equals("fst_sing")) {
                string3 = string3 + "1s";
                continue;
            }
            if (string4.equals("fst_plur")) {
                string3 = string3 + "1p";
                continue;
            }
            if (string4.equals("second")) {
                string3 = string3 + "2";
                continue;
            }
            if (string4.equals("sec_sing")) {
                string3 = string3 + "2s";
                continue;
            }
            if (string4.equals("sec_plur")) {
                string3 = string3 + "2p";
                continue;
            }
            if (string4.equals("third")) {
                string3 = string3 + "3";
                continue;
            }
            if (string4.equals("thr_sing")) {
                string3 = string3 + "3s";
                continue;
            }
            if (!string4.equals("thr_plur")) continue;
            string3 = string3 + "3p";
        }
        int n = string3.indexOf("1s1p");
        if (n > 0) {
            string3 = string3.substring(0, n + 1) + string3.substring(n + 4);
        }
        if (!inflections_.contains(string3)) {
            System.out.println("** Error: inflection '" + string3 + "' is illegal");
            string3 = "Error";
        }
        return string3;
    }

    private void GetPronInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
    }

    private void GetDetInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
    }

    private void GetPrepInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
    }

    private void GetComplInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
    }

    private void GetConjInflVars(String string, String string2, String string3, String string4) {
        this.inflValues_.addElement(new InflectionalVar(string2, string, "base", string, string3, string4));
    }

    private boolean IsUnique(Vector vector, InflectionalVar inflectionalVar) {
        boolean bl = true;
        int n = 0;
        while (n < vector.size()) {
            InflectionalVar inflectionalVar2 = (InflectionalVar)vector.elementAt(n);
            if (inflectionalVar.GetVar().equals(inflectionalVar2.GetVar()) && inflectionalVar.GetInflection().equals(inflectionalVar2.GetInflection()) && inflectionalVar.GetCat().equals(inflectionalVar2.GetCat()) && inflectionalVar.GetCit().equals(inflectionalVar2.GetCit()) && inflectionalVar.GetEui().equals(inflectionalVar2.GetEui()) && inflectionalVar.GetUnInfl().equals(inflectionalVar2.GetUnInfl())) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    static {
        inflections_.add("base");
        inflections_.add("comparative");
        inflections_.add("superlative");
        inflections_.add("plural");
        inflections_.add("presPart");
        inflections_.add("past");
        inflections_.add("pastPart");
        inflections_.add("pres3s");
        inflections_.add("positive");
        inflections_.add("singular");
        inflections_.add("infinitive");
        inflections_.add("pres123p");
        inflections_.add("pastNeg");
        inflections_.add("pres123pNeg");
        inflections_.add("pres1s");
        inflections_.add("past1p23pNeg");
        inflections_.add("past1p23p");
        inflections_.add("past1s3sNeg");
        inflections_.add("pres1p23p");
        inflections_.add("pres1p23pNeg");
        inflections_.add("past1s3s");
        inflections_.add("pres");
        inflections_.add("pres3sNeg");
        inflections_.add("presNeg");
        vowels_.add("a");
        vowels_.add("e");
        vowels_.add("i");
        vowels_.add("o");
        vowels_.add("u");
        consonants_.add("b");
        consonants_.add("c");
        consonants_.add("d");
        consonants_.add("f");
        consonants_.add("g");
        consonants_.add("h");
        consonants_.add("j");
        consonants_.add("k");
        consonants_.add("l");
        consonants_.add("m");
        consonants_.add("n");
        consonants_.add("p");
        consonants_.add("q");
        consonants_.add("r");
        consonants_.add("s");
        consonants_.add("t");
        consonants_.add("v");
        consonants_.add("w");
        consonants_.add("x");
        consonants_.add("y");
        consonants_.add("z");
        eioySets_.add("e");
        eioySets_.add("i");
        eioySets_.add("o");
        eioySets_.add("y");
    }
}

