/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.CatEntry;
import gov.nih.nlm.nls.lexCheck.Lib.Convert;
import gov.nih.nlm.nls.lexCheck.Lib.InflectionalVars;
import java.util.Vector;

public class LexRecord {
    private String base_ = null;
    private Vector spellingVars_ = new Vector();
    private String eui_ = null;
    private String category_ = null;
    private CatEntry catEntry_ = null;
    private Vector acronyms_ = new Vector();
    private Vector abbreviations_ = new Vector();
    private Vector annotations_ = new Vector();
    private String signature_ = null;
    private String end_ = "}";
    public static final int A_TAG = 1;
    public static final int A_ELEMENT = 2;
    public static final String LS = System.getProperty("line.separator").toString();

    public LexRecord() {
        this.spellingVars_ = new Vector();
        this.acronyms_ = new Vector();
        this.abbreviations_ = new Vector();
        this.annotations_ = new Vector();
    }

    public void SetLexRecord(LexRecord lexRecord) {
        this.base_ = lexRecord.GetBase();
        this.spellingVars_ = lexRecord.GetSpellingVars();
        this.eui_ = lexRecord.GetEui();
        this.category_ = lexRecord.GetCategory();
        this.catEntry_ = lexRecord.GetCatEntry();
        this.acronyms_ = lexRecord.GetAcronyms();
        this.abbreviations_ = lexRecord.GetAbbreviations();
        this.annotations_ = lexRecord.GetAnnotations();
        this.signature_ = lexRecord.GetSignature();
        this.end_ = lexRecord.GetEnd();
    }

    public void Reset() {
        this.base_ = new String();
        this.spellingVars_ = new Vector();
        this.eui_ = null;
        this.category_ = new String();
        this.catEntry_ = null;
        this.acronyms_ = new Vector();
        this.abbreviations_ = new Vector();
        this.annotations_ = new Vector();
        this.signature_ = null;
        this.end_ = "}";
    }

    public String GetXml() {
        String string = new String();
        string = LexRecord.AddToXml(string, "<lexRecord>\n");
        string = LexRecord.AddToXml(string, "\t<base>", "</base>\n", this.base_);
        string = LexRecord.AddToXml(string, "\t<eui>", "</eui>\n", this.eui_);
        string = LexRecord.AddToXml(string, "\t<cat>", "</cat>\n", this.category_);
        string = LexRecord.AddToXml(string, "\t<spellingVars>", "</spellingVars>\n", this.spellingVars_);
        string = string + InflectionalVars.GetXml(this);
        string = string + this.catEntry_.GetXml(this.category_);
        string = LexRecord.AddToXml(string, "\t<acronyms>", "</acronyms>\n", this.acronyms_);
        string = LexRecord.AddToXml(string, "\t<abbreviations>", "</abbreviations>\n", this.abbreviations_);
        string = LexRecord.AddToXml(string, "\t<annotations>", "</annotations>\n", this.annotations_);
        string = LexRecord.AddToXml(string, "\t<signature>", "</signature>\n", this.signature_);
        string = LexRecord.AddToXml(string, "</lexRecord>\n");
        return string;
    }

    public String GetText() {
        String string = new String();
        string = LexRecord.AddToText(string, "{base=", this.base_);
        string = LexRecord.AddToText(string, "spelling_variant=", this.spellingVars_);
        string = LexRecord.AddToText(string, "entry=", this.eui_);
        string = LexRecord.AddToText(string, "\tcat=", this.category_);
        string = string + this.catEntry_.GetText(this.category_);
        string = LexRecord.AddToText(string, "\tacronym_of=", this.acronyms_);
        string = LexRecord.AddToText(string, "\tabbreviation_of=", this.abbreviations_);
        string = LexRecord.AddToText(string, "annotation=", this.annotations_);
        string = LexRecord.AddToText(string, "signature=", this.signature_);
        string = LexRecord.AddToText(string, "", this.end_);
        return string;
    }

    public InflectionalVars GetInflectionalVars() {
        return new InflectionalVars(this);
    }

    public void Print() {
        System.out.print(this.GetText());
        System.out.print(this.GetXml());
    }

    public void PrintText() {
        System.out.print(this.GetText());
    }

    public void PrintXml() {
        System.out.print(this.GetXml());
    }

    public String GetBase() {
        return this.base_;
    }

    public String GetEui() {
        return this.eui_;
    }

    public Vector GetSpellingVars() {
        return this.spellingVars_;
    }

    public Vector GetAcronyms() {
        return this.acronyms_;
    }

    public Vector GetAbbreviations() {
        return this.abbreviations_;
    }

    public Vector GetAnnotations() {
        return this.annotations_;
    }

    public String GetSignature() {
        return this.signature_;
    }

    public String GetCategory() {
        return this.category_;
    }

    public String GetEnd() {
        return this.end_;
    }

    public void SetBase(String string) {
        this.base_ = string;
    }

    public void SetEui(String string) {
        this.eui_ = string;
    }

    public void SetSpellingVar(String string) {
        this.spellingVars_.add(string);
    }

    public void SetSpellingVars(Vector vector) {
        this.spellingVars_ = vector;
    }

    public void SetAcronym(String string) {
        this.acronyms_.add(string);
    }

    public void SetAbbreviation(String string) {
        this.abbreviations_.add(string);
    }

    public void SetAnnotation(String string) {
        this.annotations_.add(string);
    }

    public void SetAcronyms(Vector vector) {
        this.acronyms_ = vector;
    }

    public void SetAbbreviations(Vector vector) {
        this.abbreviations_ = vector;
    }

    public void SetAnnotations(Vector vector) {
        this.annotations_ = vector;
    }

    public void SetSignature(String string) {
        this.signature_ = string;
    }

    public void SetCat(String string) {
        this.category_ = string;
        this.catEntry_ = new CatEntry(this.category_);
    }

    public void SetCatEntry(CatEntry catEntry) {
        this.catEntry_ = catEntry;
    }

    public void SetEnd(String string) {
        this.end_ = string;
    }

    public CatEntry GetCatEntry() {
        return this.catEntry_;
    }

    public static String AddToText(String string, String string2, Vector vector) {
        if (vector == null) {
            return string;
        }
        String string3 = string;
        int n = 0;
        while (n < vector.size()) {
            string3 = string3 + string2 + (String)vector.elementAt(n) + LS;
            ++n;
        }
        return string3;
    }

    public static String AddToText(String string, String string2, String string3) {
        String string4 = string;
        if (string3 != null) {
            string4 = string4 + LexRecord.ConvertNullToNewStr(string2) + LexRecord.ConvertNullToNewStr(string3) + LS;
        }
        return string4;
    }

    public static String AddToText(String string, String string2, boolean bl) {
        String string3 = string;
        if (bl) {
            string3 = string3 + LexRecord.ConvertNullToNewStr(string2) + LS;
        }
        return string3;
    }

    public static String AddToXml(String string, String string2) {
        String string3 = string;
        string = string + string2;
        return string;
    }

    public static String AddToXml(String string, String string2, boolean bl) {
        String string3 = string;
        if (bl) {
            string = string + string2;
        }
        return string;
    }

    public static String AddToXml(String string, String string2, String string3, String string4) {
        String string5 = string;
        if (string4 != null) {
            string = string + string2 + Convert.ToNumericEntity(string4.trim()) + string3;
        }
        return string;
    }

    public static String AddToXml(String string, String string2, String string3, Vector vector) {
        if (vector == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        while (n < vector.size()) {
            String string5 = (String)vector.elementAt(n);
            string = string + string2 + Convert.ToNumericEntity(string5.trim()) + string3;
            ++n;
        }
        return string;
    }

    private static String ConvertNullToNewStr(String string) {
        if (string != null) {
            return string;
        }
        return new String();
    }

    private static String AddText(String string) {
        return LexRecord.ConvertNullToNewStr(string);
    }
}

