/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Tools;

import gov.nih.nlm.nls.lexCheck.Gram.CheckGrammer;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class LexCheck {
    private static BufferedReader inReader_ = new BufferedReader(new InputStreamReader(System.in));
    private static boolean printFlag_ = true;
    private static CheckSt st_ = new CheckSt();
    private static CheckSt catSt_ = new CheckSt(40);
    private static LineObject lineObject_ = new LineObject();
    private static boolean debugFlag_ = false;
    private static boolean textFlag_ = false;
    private static boolean xmlFlag_ = false;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            xmlFlag_ = true;
            textFlag_ = true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                debugFlag_ = true;
            } else if (stringArray[n].equals("-x")) {
                xmlFlag_ = true;
            } else if (stringArray[n].equals("-t")) {
                textFlag_ = true;
            } else if (stringArray[n].equals("-b")) {
                xmlFlag_ = true;
                textFlag_ = true;
            } else if (stringArray[n].equals("-v")) {
                System.out.println("<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
            } else {
                System.out.println("Usage: java LexCheck [-b] [-d] [-t] [-v] [-x] < inFile (text) > outFile (results)");
                System.exit(0);
            }
            ++n;
        }
        LexCheck.CheckRecord();
    }

    private static void CheckRecord() {
        if (!textFlag_ && xmlFlag_) {
            System.out.println("<lexRecords>");
        }
        try {
            do {
                if (!lineObject_.IsGoToNext()) continue;
                lineObject_.SetLine(inReader_.readLine());
                lineObject_.IncreaseLineNum();
            } while (LexCheck.CheckLine());
            inReader_.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!textFlag_ && xmlFlag_) {
            System.out.println("</lexRecords>");
        }
    }

    private static boolean CheckLine() {
        boolean bl = false;
        if (lineObject_ == null || lineObject_.GetLine() == null) {
            return false;
        }
        bl = CheckGrammer.Check(lineObject_, printFlag_, st_, catSt_, debugFlag_);
        if (st_.GetCurState() == 10 && bl) {
            if (textFlag_) {
                CheckGrammer.GetLexRecord().PrintText();
            }
            if (xmlFlag_) {
                CheckGrammer.GetLexRecord().PrintXml();
            }
        }
        return bl;
    }
}

