/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.AcronymComparator;
import gov.nih.nlm.nls.lvg.Db.AcronymRecord;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.ExpansionComparator;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Vector;

public class DbAcronym {
    public static boolean IsAcronym(String string, Connection connection) throws SQLException {
        boolean bl = false;
        String string2 = "SELECT acr FROM Acronym WHERE acrNpLc= '" + DbBase.FormatSqlStr(string) + "'";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        statement.close();
        return bl;
    }

    public static Vector GetAcronyms(String string, Connection connection) throws SQLException {
        Object object;
        String string2 = "SELECT * FROM Acronym WHERE expNpLc= '" + DbBase.FormatSqlStr(string) + "'";
        Vector<Object> vector = new Vector<Object>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            object = new AcronymRecord();
            ((AcronymRecord)object).SetAcronym(resultSet.getString("acr"));
            ((AcronymRecord)object).SetExpansion(resultSet.getString("exp"));
            ((AcronymRecord)object).SetType(resultSet.getString("aType"));
            vector.addElement(object);
        }
        resultSet.close();
        statement.close();
        object = new AcronymComparator();
        Collections.sort(vector, object);
        return vector;
    }

    public static Vector GetExpansions(String string, Connection connection) throws SQLException {
        Object object;
        String string2 = "SELECT * FROM Acronym WHERE acrNpLc= '" + DbBase.FormatSqlStr(string) + "'";
        Vector<Object> vector = new Vector<Object>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            object = new AcronymRecord();
            ((AcronymRecord)object).SetAcronym(resultSet.getString("acr"));
            ((AcronymRecord)object).SetExpansion(resultSet.getString("exp"));
            ((AcronymRecord)object).SetType(resultSet.getString("aType"));
            vector.addElement(object);
        }
        resultSet.close();
        statement.close();
        object = new ExpansionComparator();
        Collections.sort(vector, object);
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = "air conditioning";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        System.out.println("--- TestStr:  " + string);
        Configuration configuration = new Configuration("data.config.lvg", true);
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                Object object;
                Vector vector = DbAcronym.GetExpansions(string.toLowerCase(), connection);
                System.out.println("----- IsAcronym: " + DbAcronym.IsAcronym(string.toLowerCase(), connection));
                System.out.println("----- Total Expansions found: " + vector.size());
                int n = 0;
                while (n < vector.size()) {
                    object = (AcronymRecord)vector.elementAt(n);
                    System.out.println("=== Found Expansions ===");
                    System.out.println(((AcronymRecord)object).GetAcronym() + "|" + ((AcronymRecord)object).GetType() + "|" + ((AcronymRecord)object).GetExpansion());
                    ++n;
                }
                object = DbAcronym.GetAcronyms(string, connection);
                System.out.println("----- Total Acronyms found: " + ((Vector)object).size());
                int n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    AcronymRecord acronymRecord = (AcronymRecord)((Vector)object).elementAt(n2);
                    System.out.println("=== Found Acronyms ===");
                    System.out.println(acronymRecord.GetAcronym() + "|" + acronymRecord.GetType() + "|" + acronymRecord.GetExpansion());
                    ++n2;
                }
                DbBase.CloseConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

