/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Util.Str;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class DbBase {
    public static Connection OpenConnection(Configuration configuration) throws SQLException {
        String string = DbBase.GetDbDriverFromConfig(configuration);
        String string2 = DbBase.GetDbUrlFromConfig(configuration);
        Connection connection = null;
        DbBase.LoadDbDriver(string);
        connection = DriverManager.getConnection(string2);
        return connection;
    }

    public static Connection OpenConnection(Configuration configuration, Hashtable hashtable) throws SQLException {
        String string = DbBase.GetDbDriverFromConfig(configuration, hashtable);
        String string2 = DbBase.GetDbUrlFromConfig(configuration, hashtable);
        Connection connection = null;
        DbBase.LoadDbDriver(string);
        connection = DriverManager.getConnection(string2);
        return connection;
    }

    public static Connection OpenConnection(String string, String string2) throws SQLException {
        Connection connection = null;
        DbBase.LoadDbDriver(string);
        connection = DriverManager.getConnection(string2);
        return connection;
    }

    public static void CloseConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public static String FormatSqlStr(String string) {
        String string2 = Str.Replace(string, "'", "\\'");
        return string2;
    }

    static void SubmitDMLs(String string, Configuration configuration) {
        Connection connection = null;
        String string2 = DbBase.GetDbDriverFromConfig(configuration);
        DbBase.LoadDbDriver(string2);
        try {
            String string3 = DbBase.GetDbUrlFromConfig(configuration);
            connection = DriverManager.getConnection(string3);
            Statement statement = connection.createStatement();
            statement.executeQuery(string);
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    System.err.println("SQLException: " + sQLException2.getMessage());
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private static void LoadDbDriver(String string) {
        try {
            Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("** Error: Unable to load driver (" + string + ").");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static String GetDbDriverFromConfig(Configuration configuration) {
        String string = configuration.GetConfiguration("DB_DRIVER");
        return string;
    }

    private static String GetDbDriverFromConfig(Configuration configuration, Hashtable hashtable) {
        String string = Configuration.OverWriteProperty("DB_DRIVER", configuration, hashtable);
        return string;
    }

    private static String GetDbUrlFromConfig(Configuration configuration) {
        String string = configuration.GetConfiguration("DATABASE");
        String string2 = null;
        if (string.equals("IDB")) {
            string2 = "jdbc:idb:" + configuration.GetConfiguration("LVG_DIR") + configuration.GetConfiguration("IDB_PROPERTY_FILE");
        } else if (string.equals("MYSQL")) {
            String string3 = configuration.GetConfiguration("MY_SQL_HOST");
            String string4 = configuration.GetConfiguration("MY_SQL_NAME");
            String string5 = configuration.GetConfiguration("MY_SQL_USERNAME");
            String string6 = configuration.GetConfiguration("MY_SQL_PASSWORD");
            string2 = "jdbc:mysql://" + string3 + "/" + string4 + "?user=" + string5 + "&password=" + string6;
        } else if (string.equals("OTHER")) {
            string2 = configuration.GetConfiguration("JDBC_URL");
        }
        return string2;
    }

    private static String GetDbUrlFromConfig(Configuration configuration, Hashtable hashtable) {
        String string = Configuration.OverWriteProperty("DATABASE", configuration, hashtable);
        String string2 = null;
        if (string.equals("IDB")) {
            string2 = "jdbc:idb:" + Configuration.OverWriteProperty("LVG_DIR", configuration, hashtable) + Configuration.OverWriteProperty("IDB_PROPERTY_FILE", configuration, hashtable);
        } else if (string.equals("MYSQL")) {
            String string3 = Configuration.OverWriteProperty("MY_SQL_HOST", configuration, hashtable);
            String string4 = Configuration.OverWriteProperty("MY_SQL_NAME", configuration, hashtable);
            String string5 = Configuration.OverWriteProperty("MY_SQL_USERNAME", configuration, hashtable);
            String string6 = Configuration.OverWriteProperty("MY_SQL_PASSWORD", configuration, hashtable);
            string2 = "jdbc:mysql://" + string3 + "/" + string4 + "?user=" + string5 + "&password=" + string6;
        } else if (string.equals("OTHER")) {
            string2 = Configuration.OverWriteProperty("JDBC_URL", configuration, hashtable);
        }
        return string2;
    }
}

