/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.EuiRecord;
import gov.nih.nlm.nls.lvg.Db.EuiVector;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DbEui {
    public static Vector GetEuisByInflectedTerm(String string, Connection connection) throws SQLException {
        String string2 = "SELECT eui, termCat, termInfl FROM Inflection WHERE ifTermLC = '" + DbBase.FormatSqlStr(string.toLowerCase()) + "'";
        string2 = string2.trim();
        Vector vector = DbEui.GetEuis(string2, connection);
        return vector;
    }

    public static Vector GetEuisByUnflectedTerm(String string, Connection connection) throws SQLException {
        String string2 = "SELECT eui, termCat, termInfl FROM Inflection WHERE unTermLC = '" + DbBase.FormatSqlStr(string.toLowerCase()) + "'";
        string2 = string2.trim();
        Vector vector = DbEui.GetEuis(string2, connection);
        return vector;
    }

    public static String GetEuisByUnflectedTermCat(String string, int n, Connection connection) throws SQLException {
        String string2 = "SELECT eui, termCat, termInfl FROM Inflection WHERE unTermLC = '" + DbBase.FormatSqlStr(string.toLowerCase()) + "' AND termCat = " + n;
        string2 = string2.trim();
        Vector vector = DbEui.GetEuis(string2, connection);
        String string3 = "No EUI found";
        if (vector.size() == 1) {
            string3 = ((EuiRecord)vector.elementAt(0)).GetEui();
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        String string = "color";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        Configuration configuration = new Configuration("data.config.lvg", true);
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                Vector vector = DbEui.GetEuisByInflectedTerm(string, connection);
                System.out.println("----- Input term: " + string);
                System.out.println("-- Number of Inflected Eui: " + vector.size());
                int n = 0;
                while (n < vector.size()) {
                    System.out.println(n + ". EUI: " + ((EuiRecord)vector.elementAt(n)).GetEui());
                    ++n;
                }
                Vector vector2 = DbEui.GetEuisByUnflectedTerm(string, connection);
                System.out.println("-- Number of UnInflected Eui: " + vector2.size());
                int n2 = 0;
                while (n2 < vector2.size()) {
                    System.out.println(n2 + ". EUI: " + ((EuiRecord)vector2.elementAt(n2)).GetEui());
                    ++n2;
                }
                String string2 = DbEui.GetEuisByUnflectedTermCat(string, 128, connection);
                System.out.println("EUI: " + string2);
                DbBase.CloseConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private static Vector GetEuis(String string, Connection connection) throws SQLException {
        EuiVector euiVector = new EuiVector();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            EuiRecord euiRecord = new EuiRecord();
            euiRecord.SetEui(resultSet.getString("inflection.eui"));
            euiRecord.SetCategory(resultSet.getInt("inflection.termCat"));
            euiRecord.SetInflection(resultSet.getLong("inflection.termInfl"));
            euiVector.Add(euiRecord);
        }
        resultSet.close();
        statement.close();
        return euiVector;
    }
}

