/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.FruitfulComparator;
import gov.nih.nlm.nls.lvg.Db.FruitfulRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Vector;

public class DbFruitful {
    public static Vector GetFruitfulVariants(String string, Connection connection) throws SQLException {
        Object object;
        String string2 = "SELECT * FROM Fruitful WHERE termLc = '" + DbBase.FormatSqlStr(string) + "'";
        Vector<Object> vector = new Vector<Object>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            object = new FruitfulRecord();
            ((FruitfulRecord)object).SetLowerCasedTerm(resultSet.getString("termLc"));
            ((FruitfulRecord)object).SetVariantTerm(resultSet.getString("variantTerm"));
            ((FruitfulRecord)object).SetCategory(resultSet.getInt("termCat"));
            ((FruitfulRecord)object).SetInflection(resultSet.getLong("termInfl"));
            ((FruitfulRecord)object).SetOriginalCategory(resultSet.getInt("orgCat"));
            ((FruitfulRecord)object).SetOriginalInflection(resultSet.getLong("orgInfl"));
            ((FruitfulRecord)object).SetFlowHistory(resultSet.getString("flowHistory"));
            ((FruitfulRecord)object).SetDistance(resultSet.getInt("dist"));
            ((FruitfulRecord)object).SetTagInformation(resultSet.getLong("tagInfo"));
            vector.addElement(object);
        }
        resultSet.close();
        statement.close();
        object = new FruitfulComparator();
        Collections.sort(vector, object);
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = "neurological";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        System.out.println("--- TestStr:  " + string);
        Configuration configuration = new Configuration("data.config.lvg", true);
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                Vector vector = DbFruitful.GetFruitfulVariants(string, connection);
                System.out.println("----- Total Fruitful Variants found: " + vector.size());
                int n = 0;
                while (n < vector.size()) {
                    FruitfulRecord fruitfulRecord = (FruitfulRecord)vector.elementAt(n);
                    System.out.println("=== Found Fruitfuls ===");
                    System.out.println(fruitfulRecord.GetVariantTerm() + "|" + fruitfulRecord.GetCategory() + "|" + fruitfulRecord.GetInflection() + "|" + fruitfulRecord.GetOriginalCategory() + "|" + fruitfulRecord.GetOriginalInflection() + "|" + fruitfulRecord.GetFlowHistory() + "|" + fruitfulRecord.GetDistance() + "|" + fruitfulRecord.GetTagInformation());
                    ++n;
                }
                DbBase.CloseConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

