/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Db.InflectionVector;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DbInflectionUtil {
    public static Vector GetRecorsByIfTerm(String string, int n, long l, Connection connection, boolean bl) throws SQLException {
        String string2 = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = '" + DbBase.FormatSqlStr(string.toLowerCase()) + "'";
        if (n >= 0) {
            string2 = string2 + " AND termCat = " + n;
        }
        if (l >= 0L) {
            string2 = string2 + " AND termInfl = " + l;
        }
        string2 = string2.trim();
        return DbInflectionUtil.GetRecords(string2, connection, bl);
    }

    static Vector GetRecordsByIfTermCat(String string, int n, Connection connection) throws SQLException {
        String string2 = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = '" + DbBase.FormatSqlStr(string.toLowerCase()) + "' AND termCat = " + n;
        string2 = string2.trim();
        return DbInflectionUtil.GetRecords(string2, connection, false);
    }

    static InflectionRecord GetRecordByIfTerm(String string, Connection connection) throws SQLException {
        String string2 = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = '" + DbBase.FormatSqlStr(string.toLowerCase()) + "'";
        string2 = string2.trim();
        return DbInflectionUtil.GetRecord(string2, connection);
    }

    static Vector GetRecordsByIfTerm(String string, Connection connection, boolean bl) throws SQLException {
        String string2 = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = '" + DbBase.FormatSqlStr(string.toLowerCase()) + "'";
        string2 = string2.trim();
        return DbInflectionUtil.GetRecords(string2, connection, bl);
    }

    static Vector GetRecordsBeginWithIfTerm(String string, Connection connection, boolean bl) throws SQLException {
        String string2 = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC LIKE '" + DbBase.FormatSqlStr(string.toLowerCase() + "%") + "'";
        string2 = string2.trim();
        return DbInflectionUtil.GetRecords(string2, connection, bl);
    }

    static Vector GetRecordsByIfTerm(String string, long l, Connection connection, boolean bl) throws SQLException {
        String string2 = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = '" + DbBase.FormatSqlStr(string.toLowerCase()) + "'";
        if (l >= 0L) {
            string2 = string2 + " AND termInfl = " + l;
        }
        string2 = string2.trim();
        return DbInflectionUtil.GetRecords(string2, connection, bl);
    }

    static InflectionRecord GetRecord(String string, Connection connection) throws SQLException {
        InflectionRecord inflectionRecord = new InflectionRecord();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            inflectionRecord.SetInflectedTerm(resultSet.getString("ifTerm"));
            inflectionRecord.SetUnInflectedTerm(resultSet.getString("unTerm"));
            inflectionRecord.SetEui(resultSet.getString("eui"));
            inflectionRecord.SetCategory(resultSet.getInt("termCat"));
            inflectionRecord.SetInflection(resultSet.getLong("termInfl"));
            inflectionRecord.SetCitationTerm(resultSet.getString("ctTerm"));
        }
        resultSet.close();
        statement.close();
        return inflectionRecord;
    }

    static Vector GetRecords(String string, Connection connection, boolean bl) throws SQLException {
        InflectionVector inflectionVector = new InflectionVector();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            InflectionRecord inflectionRecord = new InflectionRecord();
            inflectionRecord.SetInflectedTerm(resultSet.getString("ifTerm"));
            inflectionRecord.SetUnInflectedTerm(resultSet.getString("unTerm"));
            inflectionRecord.SetEui(resultSet.getString("eui"));
            inflectionRecord.SetCategory(resultSet.getInt("termCat"));
            inflectionRecord.SetInflection(resultSet.getLong("termInfl"));
            inflectionRecord.SetCitationTerm(resultSet.getString("ctTerm"));
            if (bl && inflectionVector.ContainEui(inflectionRecord.GetEui())) continue;
            inflectionVector.addElement(inflectionRecord);
        }
        resultSet.close();
        statement.close();
        return inflectionVector;
    }
}

