/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.SynonymComparator;
import gov.nih.nlm.nls.lvg.Db.SynonymRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Vector;

public class DbSynonym {
    public static Vector GetSynonyms(String string, Connection connection) throws SQLException {
        Object object;
        String string2 = "SELECT * FROM LexSynonym WHERE keyFormNpLc = '" + DbBase.FormatSqlStr(string) + "'";
        Vector<Object> vector = new Vector<Object>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            object = new SynonymRecord();
            ((SynonymRecord)object).SetKeyFormNpLc(resultSet.getString("keyFormNpLc"));
            ((SynonymRecord)object).SetKeyForm(resultSet.getString("keyForm"));
            ((SynonymRecord)object).SetSynonym(resultSet.getString("aSynonym"));
            ((SynonymRecord)object).SetCat1(resultSet.getInt("cat1"));
            ((SynonymRecord)object).SetCat2(resultSet.getInt("cat2"));
            vector.addElement(object);
        }
        resultSet.close();
        statement.close();
        object = new SynonymComparator();
        Collections.sort(vector, object);
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = "aminophylline";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        System.out.println("--- TestStr:  " + string);
        Configuration configuration = new Configuration("data.config.lvg", true);
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                Vector vector = DbSynonym.GetSynonyms(string, connection);
                System.out.println("----- Total Synonyms found: " + vector.size());
                int n = 0;
                while (n < vector.size()) {
                    SynonymRecord synonymRecord = (SynonymRecord)vector.elementAt(n);
                    System.out.println("=== Found Synonyms ===");
                    System.out.println(synonymRecord.GetKeyFormNpLc() + "|" + synonymRecord.GetKeyForm() + "|" + synonymRecord.GetCat1() + "|" + synonymRecord.GetSynonym() + "|" + synonymRecord.GetCat2());
                    ++n;
                }
                DbBase.CloseConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

