/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.CanonRecord;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbCanon;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToCanonicalize
extends Transformation {
    private static final String INFO = "Canonicalize";

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2) throws SQLException {
        CanonInfo canonInfo = ToCanonicalize.CanonicalizeWords(lexItem.GetSourceTerm().toLowerCase(), connection);
        String string = canonInfo.GetCanonTerm();
        String string2 = canonInfo.GetCanonNum();
        String string3 = null;
        String string4 = null;
        if (bl) {
            string3 = "Canonicalize (" + string2 + ")";
        }
        if (bl2) {
            string4 = string2 + GlobalBehavior.GetFieldSeparator();
        }
        Vector<LexItem> vector = new Vector<LexItem>();
        LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string, 10, -1L, -1L, string3, string4);
        vector.addElement(lexItem2);
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "being");
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToCanonicalize.Mutate(lexItem, connection, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static CanonInfo CanonicalizeWords(String string, Connection connection) throws SQLException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        Vector<CanonRecord> vector = new Vector<CanonRecord>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            object = ToCanonicalize.CanonicalizeWord(string2, connection);
            vector.addElement((CanonRecord)object);
        }
        int n = 0;
        while (n < vector.size()) {
            object = (CanonRecord)vector.elementAt(n);
            stringBuffer.append(((CanonRecord)object).GetCanonicalizedTerm());
            stringBuffer.append(" ");
            stringBuffer2.append(((CanonRecord)object).GetCanonicalId());
            stringBuffer2.append(" ");
            ++n;
        }
        object = new CanonInfo(stringBuffer.toString().trim(), stringBuffer2.toString().trim());
        return object;
    }

    private static CanonRecord CanonicalizeWord(String string, Connection connection) throws SQLException {
        CanonRecord canonRecord = new CanonRecord(string);
        Vector vector = DbCanon.GetCanons(string, connection);
        if (vector.size() == 1) {
            canonRecord = (CanonRecord)vector.elementAt(0);
        }
        return canonRecord;
    }

    private static class CanonInfo {
        private String canonTerm_ = null;
        private String canonNum_ = null;

        private CanonInfo(String string, String string2) {
            this.canonTerm_ = string;
            this.canonNum_ = string2;
        }

        private String GetCanonTerm() {
            return this.canonTerm_;
        }

        private String GetCanonNum() {
            return this.canonNum_;
        }
    }
}

