/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbCitation;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToCitation
extends Transformation {
    private static final String INFO = "Citation";

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2) throws SQLException {
        Vector vector = ToCitation.GetCitation(lexItem, connection, INFO, bl, bl2);
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "Colour");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToCitation.Mutate(lexItem, connection, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector GetCitation(LexItem lexItem, Connection connection, String string, boolean bl, boolean bl2) {
        String string2 = lexItem.GetSourceTerm();
        long l = lexItem.GetSourceCategory().GetValue();
        long l2 = lexItem.GetSourceInflection().GetValue();
        Vector<Object> vector = new Vector<Object>();
        try {
            Vector vector2 = DbCitation.GetCitations(string2, connection);
            int n = 0;
            while (n < vector2.size()) {
                InflectionRecord inflectionRecord = (InflectionRecord)vector2.elementAt(n);
                String string3 = inflectionRecord.GetCitationTerm();
                String string4 = inflectionRecord.GetUninflectedTerm();
                long l3 = inflectionRecord.GetCategory();
                long l4 = inflectionRecord.GetInflection();
                if (InputFilter.IsLegal(l, l3)) {
                    Object object;
                    String string5 = null;
                    String string6 = null;
                    if (bl) {
                        string5 = string;
                    }
                    if (bl2) {
                        object = GlobalBehavior.GetFieldSeparator();
                        string6 = string2 + (String)object + string4 + (String)object + Category.ToName(l3) + (String)object + Inflection.ToName(l4) + (String)object + string3 + (String)object + inflectionRecord.GetEui() + (String)object;
                    }
                    object = Transformation.UpdateLexItem(lexItem, string3, 38, l3, Inflection.GetBitValue(0), string5, string6);
                    vector.addElement(object);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }
}

