/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbDerivation;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.DerivationRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class ToDerivation
extends Transformation
implements Cloneable {
    private static final String INFO = "Derivation";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, boolean bl, boolean bl2) {
        Vector vector = ToDerivation.GetDerivations(lexItem, connection, ramTrie, n, INFO, bl, bl2);
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "help");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = false;
            RamTrie ramTrie = new RamTrie(bl, n, string2, n2);
            if (connection != null) {
                vector = ToDerivation.Mutate(lexItem, connection, ramTrie, 1, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    protected static Vector GetDerivations(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, String string, boolean bl, boolean bl2) {
        Object object;
        String string2 = lexItem.GetSourceTerm();
        Vector vector = new Vector();
        long l = lexItem.GetSourceCategory().GetValue();
        long l2 = lexItem.GetSourceInflection().GetValue();
        try {
            LexItem lexItem2;
            String string3;
            String string4;
            Object object2;
            object = DbDerivation.GetDerivations(string2, connection);
            int n2 = 0;
            while (n2 < ((Vector)object).size()) {
                object2 = (DerivationRecord)((Vector)object).elementAt(n2);
                String string5 = ((DerivationRecord)object2).GetTarget();
                long l3 = ((DerivationRecord)object2).GetSourceCat();
                if (InputFilter.IsLegal(l, l3)) {
                    string4 = null;
                    string3 = null;
                    if (bl) {
                        string4 = string + " (FACT)";
                    }
                    if (bl2) {
                        string3 = "FACT" + GlobalBehavior.GetFieldSeparator() + ((DerivationRecord)object2).GetString(GlobalBehavior.GetFieldSeparator());
                    }
                    lexItem2 = Transformation.UpdateLexItem(lexItem, string5, 18, ((DerivationRecord)object2).GetTargetCat(), Inflection.GetBitValue(0), string4, string3);
                    vector.addElement(lexItem2);
                }
                ++n2;
            }
            object2 = ramTrie.GetDerivationsByRules(string2, l, l2, true);
            int n3 = 0;
            while (n3 < ((Vector)object2).size()) {
                RuleResult ruleResult = (RuleResult)((Vector)object2).elementAt(n3);
                String string6 = ruleResult.GetOutTerm();
                string4 = null;
                string3 = null;
                if (bl) {
                    string4 = string + " (RULE|" + ruleResult.GetRuleString() + ")";
                }
                if (bl2) {
                    string3 = "RULE" + GlobalBehavior.GetFieldSeparator() + ruleResult.GetRuleString() + GlobalBehavior.GetFieldSeparator();
                }
                lexItem2 = Transformation.UpdateLexItem(lexItem, string6, 18, Category.ToValue(ruleResult.GetOutCategory()), Inflection.ToValue(ruleResult.GetOutInflection()), string4, string3);
                vector.addElement(lexItem2);
                ++n3;
            }
            vector = ToDerivation.RestrictDerivations(vector, connection, n);
        }
        catch (SQLException sQLException) {
            System.out.println("** Error: Sql Exception in ToDerivation Flow.");
        }
        object = new LexItemComparator();
        ((LexItemComparator)object).SetRule(10);
        Collections.sort(vector, object);
        return vector;
    }

    protected static Vector RestrictDerivations(Vector vector, Connection connection, int n) throws SQLException {
        Vector vector2 = new Vector();
        switch (n) {
            case 2: {
                vector2 = ToDerivation.VerifyDerivationsFromLvg(vector, connection);
                if (vector2.size() != 0) break;
                vector2.addAll(vector);
                break;
            }
            case 3: {
                vector2.addAll(vector);
                break;
            }
            default: {
                vector2 = ToDerivation.VerifyDerivationsFromLvg(vector, connection);
            }
        }
        return vector2;
    }

    private static Vector VerifyDerivationsFromLvg(Vector vector, Connection connection) throws SQLException {
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            String string = lexItem.GetTargetTerm();
            if (DbUninflection.IsExistUninflectedTerm(string, connection)) {
                vector2.addElement(lexItem);
            }
            ++n;
        }
        return vector2;
    }
}

