/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToDerivation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.util.Vector;

public class ToDerivationByCategory
extends Transformation
implements Cloneable {
    private static final String INFO = "DerivationByCategory";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, long l, boolean bl, boolean bl2) {
        String string = "DerivationByCategory <" + l + ">";
        Vector vector = ToDerivation.GetDerivations(lexItem, connection, ramTrie, n, string, bl, bl2);
        Vector vector2 = ToDerivationByCategory.RestrictOutputByCategory(vector, l);
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "help");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = false;
            RamTrie ramTrie = new RamTrie(bl, n, string2, n2);
            if (connection != null) {
                vector = ToDerivationByCategory.Mutate(lexItem, connection, ramTrie, 1, 128L, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector RestrictOutputByCategory(Vector vector, long l) {
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            if (OutputFilter.IsCategoryOK(lexItem, l)) {
                vector2.addElement(lexItem);
            }
            ++n;
        }
        return vector2;
    }
}

