/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFilter
extends Transformation
implements Cloneable {
    private static final String INFO = "Filter Output";

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2) throws SQLException {
        Object object;
        Vector vector = ToFilter.GetCatInfl(lexItem.GetSourceTerm(), connection);
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            object = (InflectionRecord)vector.elementAt(n);
            ToFilter.AddRecordToCombined((InflectionRecord)object, vector2);
            ++n;
        }
        object = new Vector();
        int n2 = 0;
        while (n2 < vector2.size()) {
            InflectionRecord inflectionRecord = (InflectionRecord)vector2.elementAt(n2);
            String string = inflectionRecord.GetInflectedTerm();
            String string2 = null;
            String string3 = null;
            if (bl) {
                string2 = INFO;
            }
            if (bl2) {
                string3 = Category.ToName(inflectionRecord.GetCategory()) + GlobalBehavior.GetFieldSeparator() + Inflection.ToName(inflectionRecord.GetInflection()) + GlobalBehavior.GetFieldSeparator();
            }
            LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string, 29, inflectionRecord.GetCategory(), inflectionRecord.GetInflection(), string2, string3);
            ((Vector)object).addElement(lexItem2);
            ++n2;
        }
        return object;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "bloom");
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToFilter.Mutate(lexItem, connection, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static void AddRecordToCombined(InflectionRecord inflectionRecord, Vector vector) {
        if (vector.size() == 0) {
            vector.addElement(inflectionRecord);
        } else {
            boolean bl = false;
            int n = 0;
            while (n < vector.size()) {
                InflectionRecord inflectionRecord2 = (InflectionRecord)vector.elementAt(n);
                if (inflectionRecord2.GetInflectedTerm().equalsIgnoreCase(inflectionRecord.GetInflectedTerm())) {
                    bl = true;
                    inflectionRecord2.SetCategory(Bit.Add(inflectionRecord2.GetCategory(), inflectionRecord.GetCategory()));
                    inflectionRecord2.SetInflection(Bit.Add(inflectionRecord2.GetInflection(), inflectionRecord.GetInflection()));
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector.addElement(inflectionRecord);
            }
        }
    }

    private static Vector GetCatInfl(String string, Connection connection) throws SQLException {
        Vector vector = DbInflection.GetCatInfl(string, connection);
        return vector;
    }
}

