/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariants;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFruitfulVariantsLex
extends Transformation
implements Cloneable {
    private static final String INFO = "Generate Known Fruitful Variants";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, RamTrie ramTrie2, boolean bl, boolean bl2) throws SQLException {
        Vector vector = ToFruitfulVariants.GetNoOperationSet(lexItem, connection, ramTrie, bl, true);
        Vector vector2 = ToFruitfulVariants.GetVariantSet(lexItem, connection, ramTrie, ramTrie2, bl);
        Vector vector3 = ToFruitfulVariants.GetSpellingAndInflections(vector2, connection, ramTrie, bl, 1);
        vector = ToFruitfulVariants.AddToVariantList(vector, vector3);
        String string = Flow.GetBitName(45, 1);
        Vector vector4 = ToFruitfulVariants.GetFinalSet(vector, string, bl2);
        return vector4;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "neurological");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            RamTrie ramTrie = new RamTrie(true, n, string2, 0);
            RamTrie ramTrie2 = new RamTrie(false, n, string2, n2);
            if (connection != null) {
                vector = ToFruitfulVariantsLex.Mutate(lexItem, connection, ramTrie, ramTrie2, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }
}

