/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.util.Collections;
import java.util.Vector;

public class ToInflection
extends Transformation
implements Cloneable {
    private static final String INFO = "Inflection";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, boolean bl, boolean bl2) {
        Vector vector = ToInflection.InflectWords(lexItem, connection, ramTrie, n, INFO, bl, bl2, 1);
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "sleep");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection == null) {
                System.out.println("** Error: Db connection problem!");
            }
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector = ToInflection.Mutate(lexItem, connection, ramTrie, 2, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    static Vector InflectWords(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, String string, boolean bl, boolean bl2, int n2) {
        Object object;
        String string2 = lexItem.GetSourceTerm();
        long l = lexItem.GetSourceCategory().GetValue();
        long l2 = lexItem.GetSourceInflection().GetValue();
        Vector vector = new Vector();
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            object = DbInflection.GetInflections(string2, l, l2, connection);
            Vector<Object> vector2 = new Vector<Object>();
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                object5 = (InflectionRecord)((Vector)object).elementAt(n3);
                object4 = ((InflectionRecord)object5).GetInflectedTerm();
                String string3 = null;
                object3 = null;
                if (bl) {
                    string3 = string + " (FACT|" + ((InflectionRecord)object5).GetUninflectedTerm() + "|" + Category.ToName(((InflectionRecord)object5).GetCategory()) + "|base)";
                }
                if (bl2) {
                    object2 = GlobalBehavior.GetFieldSeparator();
                    object3 = "FACT" + (String)object2 + ((InflectionRecord)object5).GetUninflectedTerm() + (String)object2 + Category.ToName(((InflectionRecord)object5).GetCategory()) + (String)object2 + "base" + (String)object2 + (String)object4 + (String)object2 + Category.ToName(((InflectionRecord)object5).GetCategory()) + (String)object2 + Inflection.ToName(((InflectionRecord)object5).GetInflection()) + (String)object2;
                }
                object2 = Transformation.UpdateLexItem(lexItem, (String)object4, n2, ((InflectionRecord)object5).GetCategory(), ((InflectionRecord)object5).GetInflection(), string3, (String)object3);
                vector2.addElement(object2);
                ++n3;
            }
            object5 = new Vector();
            if (n == 3 || n == 2 && vector2.size() == 0) {
                object4 = ramTrie.GetInflectedTermsByRules(string2, l, l2, true);
                int n4 = 0;
                while (n4 < ((Vector)object4).size()) {
                    object3 = (RuleResult)((Vector)object4).elementAt(n4);
                    object2 = ((RuleResult)object3).GetOutTerm();
                    if (!DbInflection.IsExistInflectedTerm((String)object2, connection)) {
                        Object object6;
                        String string4 = null;
                        String string5 = null;
                        if (bl) {
                            string4 = string + " (RULE|" + ((RuleResult)object3).GetInTerm() + "|" + ((RuleResult)object3).GetRuleString() + ")";
                        }
                        if (bl2) {
                            object6 = GlobalBehavior.GetFieldSeparator();
                            string5 = "RULE" + (String)object6 + ((RuleResult)object3).GetInTerm() + (String)object6 + ((RuleResult)object3).GetRuleString() + (String)object6;
                        }
                        object6 = Transformation.UpdateLexItem(lexItem, (String)object2, n2, Category.ToValue(((RuleResult)object3).GetOutCategory()), Inflection.ToValue(((RuleResult)object3).GetOutInflection()), string4, string5);
                        ((Vector)object5).addElement(object6);
                    }
                    ++n4;
                }
            }
            vector = OutputFilter.RestrictOption(vector2, (Vector)object5, n);
        }
        catch (Exception exception) {
            System.err.println("** Error: Sql Exception in ToInflection Flow.");
        }
        object = new LexItemComparator();
        ((LexItemComparator)object).SetRule(10);
        Collections.sort(vector, object);
        return vector;
    }
}

