/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToCanonicalize;
import gov.nih.nlm.nls.lvg.Flows.ToLowerCase;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveGenitive;
import gov.nih.nlm.nls.lvg.Flows.ToReplacePunctuationWithSpace;
import gov.nih.nlm.nls.lvg.Flows.ToSortWordsByOrder;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectWords;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToLuiNormalize
extends Transformation
implements Cloneable {
    private static final int LUI_NORM_STEPS = 7;

    public static Vector Mutate(LexItem lexItem, int n, Vector vector, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Vector vector2 = new Vector();
        Vector<LexItem> vector3 = new Vector<LexItem>();
        vector3.addElement(lexItem);
        int n2 = 0;
        while (n2 < 7) {
            vector2 = ToLuiNormalize.GetLuiNormBySteps(n2, vector3, n, vector, connection, ramTrie, bl, bl2);
            vector3.removeAllElements();
            int n3 = 0;
            while (n3 < vector2.size()) {
                LexItem lexItem2 = (LexItem)vector2.elementAt(n3);
                LexItem lexItem3 = LexItem.TargetToSource(lexItem2);
                vector3.addElement(lexItem3);
                ++n3;
            }
            ++n2;
        }
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "fingers");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        Vector vector = ToStripStopWords.GetStopWordsFromFile(configuration);
        LexItem lexItem = new LexItem(string);
        Vector vector2 = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector2 = ToLuiNormalize.Mutate(lexItem, n2, vector, connection, ramTrie, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector2);
    }

    private static Vector GetLuiNormBySteps(int n, Vector vector, int n2, Vector vector2, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Vector vector3 = new Vector();
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n3);
            Vector vector4 = new Vector();
            switch (n) {
                case 0: {
                    vector4 = ToRemoveGenitive.Mutate(lexItem, bl, bl2);
                    break;
                }
                case 1: {
                    vector4 = ToReplacePunctuationWithSpace.Mutate(lexItem, bl, bl2);
                    break;
                }
                case 2: {
                    vector4 = ToStripStopWords.Mutate(lexItem, vector2, bl, bl2);
                    break;
                }
                case 3: {
                    vector4 = ToLowerCase.Mutate(lexItem, bl, bl2);
                    break;
                }
                case 4: {
                    vector4 = ToUninflectWords.Mutate(lexItem, n2, connection, ramTrie, bl, bl2);
                    break;
                }
                case 5: {
                    vector4 = ToCanonicalize.Mutate(lexItem, connection, bl, bl2);
                    break;
                }
                case 6: {
                    vector4 = ToSortWordsByOrder.Mutate(lexItem, bl, bl2);
                }
            }
            vector3.addAll(vector4);
            if (n == 5) break;
            ++n3;
        }
        return vector3;
    }
}

