/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbCitation;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectWords;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import gov.nih.nlm.nls.lvg.Util.LvgComparator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToNormUninflectWords
extends Transformation {
    private static final String INFO = "Normalize Uninflect Words";

    public static Vector Mutate(LexItem lexItem, int n, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Vector vector = ToNormUninflectWords.NormUninflectWords(lexItem.GetSourceTerm(), n, connection, ramTrie);
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            String string2 = null;
            String string3 = null;
            if (bl) {
                string2 = INFO;
            }
            if (bl2) {
                string3 = Transformation.NO_MUTATE_INFO;
            }
            LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string, 39, 2047L, Inflection.GetBitValue(0), string2, string3);
            vector2.addElement(lexItem2);
            ++n2;
        }
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "Color colour");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector = ToNormUninflectWords.Mutate(lexItem, n2, connection, ramTrie, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector NormUninflectWords(String string, int n, Connection connection, RamTrie ramTrie) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        long l = 1L;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            try {
                String string2;
                Object object2;
                Vector vector3 = DbCitation.GetCitations((String)object, connection);
                Vector<String> vector4 = new Vector<String>();
                int n2 = 0;
                while (n2 < vector3.size()) {
                    object2 = (InflectionRecord)vector3.elementAt(n2);
                    string2 = ((InflectionRecord)object2).GetCitationTerm();
                    String string3 = string2.toLowerCase();
                    if (!vector4.contains(string3)) {
                        vector4.addElement(string3);
                    }
                    ++n2;
                }
                if (vector3.size() == 0) {
                    object2 = ramTrie.GetUninflectedTermsByRules((String)object, 2047L, 0xFFFFFFL, true);
                    string2 = null;
                    int n3 = 0;
                    while (n3 < ((Vector)object2).size()) {
                        RuleResult ruleResult = (RuleResult)((Vector)object2).elementAt(n3);
                        String string4 = ruleResult.GetOutTerm();
                        String string5 = string4.toLowerCase();
                        if (!DbUninflection.IsExistUninflectedTerm(string5, connection)) {
                            if (string2 == null) {
                                string2 = string5;
                            } else if (string5.compareTo(string2) < 0 && !DbUninflection.IsExistUninflectedTerm(string4, connection)) {
                                string2 = string5;
                            }
                        }
                        ++n3;
                    }
                    vector4.addElement(string2);
                }
                if ((l *= (long)vector4.size()) > (long)n) {
                    vector.removeAllElements();
                    vector.addElement(string);
                    return vector;
                }
                vector2.addElement(vector4);
            }
            catch (Exception exception) {
                break;
            }
        }
        vector = ToUninflectWords.FormCombinations(vector2);
        if (vector2.size() >= 1) {
            object = new LvgComparator();
            ((LvgComparator)object).SetLengthFlag(true);
            ((LvgComparator)object).SetCase(false);
            Collections.sort(vector, object);
        }
        return vector;
    }
}

